/*
 * Decompiled with CFR 0.152.
 */
package io.dgraph;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;

public class ExceptionUtil {
    public static RuntimeException unwrapException(CompletionException ex) {
        if (ex.getCause() instanceof RuntimeException) {
            return (RuntimeException)ex.getCause();
        }
        return ex;
    }

    public static <R> R withExceptionUnwrapped(Supplier<R> s) {
        try {
            return s.get();
        }
        catch (CompletionException ex) {
            throw ExceptionUtil.unwrapException(ex);
        }
    }

    public static void withExceptionUnwrapped(Runnable r) {
        try {
            r.run();
        }
        catch (CompletionException ex) {
            throw ExceptionUtil.unwrapException(ex);
        }
    }

    public static boolean isJwtExpired(Throwable e) {
        Throwable cause = e;
        while (cause.getCause() != null && !(cause instanceof StatusRuntimeException)) {
            cause = cause.getCause();
        }
        if (cause instanceof StatusRuntimeException) {
            StatusRuntimeException runtimeException = (StatusRuntimeException)cause;
            return runtimeException.getStatus().getCode().equals((Object)Status.Code.UNAUTHENTICATED) && runtimeException.getMessage().contains("Token is expired");
        }
        return false;
    }
}

