/*
 * Decompiled with CFR 0.152.
 */
package io.dgraph;

import io.dgraph.DgraphAsyncClient;
import io.dgraph.DgraphGrpc;
import io.dgraph.DgraphProto;
import io.dgraph.ExceptionUtil;
import io.dgraph.Transaction;
import io.grpc.Channel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Executor;

public class DgraphClient {
    private static final String gRPC_AUTHORIZATION_HEADER_NAME = "authorization";
    private final DgraphAsyncClient asyncClient;

    @Deprecated
    public static DgraphGrpc.DgraphStub clientStubFromSlashEndpoint(String slashEndpoint, String apiKey) throws MalformedURLException {
        return DgraphClient.clientStubFromCloudEndpoint(slashEndpoint, apiKey);
    }

    public static DgraphGrpc.DgraphStub clientStubFromCloudEndpoint(String cloudEndpoint, String apiKey) throws MalformedURLException {
        String[] parts = new URL(cloudEndpoint).getHost().split("[.]", 2);
        if (parts.length < 2) {
            throw new MalformedURLException("Invalid Dgraph Cloud URL.");
        }
        String gRPCAddress = parts[0] + ".grpc." + parts[1];
        Metadata metadata = new Metadata();
        metadata.put(Metadata.Key.of((String)gRPC_AUTHORIZATION_HEADER_NAME, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)apiKey);
        return (DgraphGrpc.DgraphStub)MetadataUtils.attachHeaders((AbstractStub)DgraphGrpc.newStub((Channel)ManagedChannelBuilder.forAddress((String)gRPCAddress, (int)443).useTransportSecurity().build()), (Metadata)metadata);
    }

    public DgraphClient(DgraphGrpc.DgraphStub ... stubs) {
        this.asyncClient = new DgraphAsyncClient(stubs);
    }

    public DgraphClient(Executor executor, DgraphGrpc.DgraphStub ... stubs) {
        this.asyncClient = new DgraphAsyncClient(executor, stubs);
    }

    public Transaction newTransaction() {
        return new Transaction(this.asyncClient.newTransaction());
    }

    public Transaction newTransaction(DgraphProto.TxnContext context) {
        return new Transaction(this.asyncClient.newTransaction(context));
    }

    public Transaction newReadOnlyTransaction() {
        return new Transaction(this.asyncClient.newReadOnlyTransaction());
    }

    public Transaction newReadOnlyTransaction(DgraphProto.TxnContext context) {
        return new Transaction(this.asyncClient.newReadOnlyTransaction(context));
    }

    public void alter(DgraphProto.Operation op) {
        ExceptionUtil.withExceptionUnwrapped(() -> this.asyncClient.alter(op).join());
    }

    public DgraphProto.Version checkVersion() {
        return this.asyncClient.checkVersion().join();
    }

    public void login(String userid, String password) {
        this.asyncClient.login(userid, password).join();
    }

    public void loginIntoNamespace(String userid, String password, long namespace) {
        this.asyncClient.loginIntoNamespace(userid, password, namespace).join();
    }
}

