/*
 * Decompiled with CFR 0.152.
 */
package io.dgraph;

import com.google.protobuf.InvalidProtocolBufferException;
import io.dgraph.AsyncTransaction;
import io.dgraph.DgraphGrpc;
import io.dgraph.DgraphProto;
import io.dgraph.ExceptionUtil;
import io.dgraph.StreamObserverBridge;
import io.dgraph.TxnConflictException;
import io.grpc.Context;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DgraphAsyncClient {
    private static final Logger LOG = LoggerFactory.getLogger(DgraphAsyncClient.class);
    private final List<DgraphGrpc.DgraphStub> stubs;
    private final Executor executor;
    private final ReadWriteLock jwtLock;
    private DgraphProto.Jwt jwt;

    public DgraphAsyncClient(DgraphGrpc.DgraphStub ... stubs) {
        this.stubs = Arrays.asList(stubs);
        this.executor = ForkJoinPool.commonPool();
        this.jwtLock = new ReentrantReadWriteLock();
    }

    public DgraphAsyncClient(Executor executor, DgraphGrpc.DgraphStub ... stubs) {
        this.stubs = Arrays.asList(stubs);
        this.executor = executor;
        this.jwtLock = new ReentrantReadWriteLock();
    }

    public CompletableFuture<Void> login(String userid, String password) {
        return this.loginIntoNamespace(userid, password, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> loginIntoNamespace(String userid, String password, long namespace) {
        Lock wlock = this.jwtLock.writeLock();
        wlock.lock();
        try {
            DgraphGrpc.DgraphStub client = this.anyClient();
            DgraphProto.LoginRequest loginRequest = DgraphProto.LoginRequest.newBuilder().setUserid(userid).setPassword(password).setNamespace(namespace).build();
            StreamObserverBridge<DgraphProto.Response> bridge = new StreamObserverBridge<DgraphProto.Response>();
            client.login(loginRequest, bridge);
            CompletionStage completionStage = bridge.getDelegate().thenAccept(response -> {
                try {
                    this.jwt = DgraphProto.Jwt.parseFrom(response.getJson());
                }
                catch (InvalidProtocolBufferException e) {
                    String errmsg = "error while parsing jwt from the response: ";
                    LOG.error(errmsg, (Throwable)e);
                    throw new RuntimeException(errmsg, e);
                }
            });
            return completionStage;
        }
        finally {
            wlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> retryLogin() {
        Lock wlock = this.jwtLock.writeLock();
        wlock.lock();
        try {
            if (this.jwt.getRefreshJwt().isEmpty()) {
                CompletableFuture<Void> future = new CompletableFuture<Void>();
                future.completeExceptionally(new Exception("refresh JWT should not be empty"));
                CompletableFuture<Void> completableFuture = future;
                return completableFuture;
            }
            DgraphGrpc.DgraphStub client = this.anyClient();
            DgraphProto.LoginRequest loginRequest = DgraphProto.LoginRequest.newBuilder().setRefreshToken(this.jwt.getRefreshJwt()).build();
            StreamObserverBridge<DgraphProto.Response> bridge = new StreamObserverBridge<DgraphProto.Response>();
            client.login(loginRequest, bridge);
            CompletionStage completionStage = bridge.getDelegate().thenAccept(response -> {
                try {
                    this.jwt = DgraphProto.Jwt.parseFrom(response.getJson());
                }
                catch (InvalidProtocolBufferException e) {
                    LOG.error("error while parsing jwt from the response: ", (Throwable)e);
                }
            });
            return completionStage;
        }
        finally {
            wlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DgraphGrpc.DgraphStub getStubWithJwt(DgraphGrpc.DgraphStub stub) {
        Lock readLock = this.jwtLock.readLock();
        readLock.lock();
        try {
            if (this.jwt != null && !this.jwt.getAccessJwt().isEmpty()) {
                Metadata metadata = new Metadata();
                metadata.put(Metadata.Key.of((String)"accessJwt", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)this.jwt.getAccessJwt());
                DgraphGrpc.DgraphStub dgraphStub = (DgraphGrpc.DgraphStub)MetadataUtils.attachHeaders((AbstractStub)stub, (Metadata)metadata);
                return dgraphStub;
            }
            DgraphGrpc.DgraphStub dgraphStub = stub;
            return dgraphStub;
        }
        finally {
            readLock.unlock();
        }
    }

    protected <T> CompletableFuture<T> runWithRetries(String operation, Callable<CompletableFuture<T>> callable) {
        Callable ctxCallable = Context.current().wrap(callable);
        return CompletableFuture.supplyAsync(() -> {
            try {
                return ((CompletableFuture)ctxCallable.call()).get();
            }
            catch (InterruptedException e) {
                LOG.error("The " + operation + " got interrupted:", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                if (ExceptionUtil.isJwtExpired(e.getCause())) {
                    try {
                        this.retryLogin().get();
                        return ((CompletableFuture)ctxCallable.call()).get();
                    }
                    catch (InterruptedException ie) {
                        LOG.error("The retried " + operation + " got interrupted:", (Throwable)ie);
                        throw new RuntimeException(ie);
                    }
                    catch (ExecutionException ie) {
                        LOG.error("The retried " + operation + " encounters an execution exception:", (Throwable)ie);
                        throw new RuntimeException(ie);
                    }
                    catch (Exception ie) {
                        LOG.error("The retried " + operation + " encounters a completion exception:", (Throwable)ie);
                        throw new CompletionException(ie);
                    }
                }
                if (e.getCause() instanceof StatusRuntimeException) {
                    StatusRuntimeException ex1 = (StatusRuntimeException)e.getCause();
                    Status.Code code = ex1.getStatus().getCode();
                    String desc = ex1.getStatus().getDescription();
                    if (code.equals((Object)Status.Code.ABORTED) || code.equals((Object)Status.Code.FAILED_PRECONDITION)) {
                        throw new CompletionException(new TxnConflictException(desc));
                    }
                }
                throw new RuntimeException("The " + operation + " encountered an execution exception:", e);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, this.executor);
    }

    public CompletableFuture<DgraphProto.Payload> alter(DgraphProto.Operation op) {
        DgraphGrpc.DgraphStub stub = this.anyClient();
        return this.runWithRetries("alter", () -> {
            StreamObserverBridge<DgraphProto.Payload> observerBridge = new StreamObserverBridge<DgraphProto.Payload>();
            DgraphGrpc.DgraphStub localStub = this.getStubWithJwt(stub);
            localStub.alter(op, observerBridge);
            return observerBridge.getDelegate();
        });
    }

    public CompletableFuture<DgraphProto.Version> checkVersion() {
        DgraphGrpc.DgraphStub stub = this.anyClient();
        DgraphProto.Check checkRequest = DgraphProto.Check.newBuilder().build();
        return this.runWithRetries("checkVersion", () -> {
            StreamObserverBridge<DgraphProto.Version> observerBridge = new StreamObserverBridge<DgraphProto.Version>();
            DgraphGrpc.DgraphStub localStub = this.getStubWithJwt(stub);
            localStub.checkVersion(checkRequest, observerBridge);
            return observerBridge.getDelegate();
        });
    }

    private DgraphGrpc.DgraphStub anyClient() {
        int index = ThreadLocalRandom.current().nextInt(this.stubs.size());
        DgraphGrpc.DgraphStub rawStub = this.stubs.get(index);
        return this.getStubWithJwt(rawStub);
    }

    public AsyncTransaction newTransaction() {
        return new AsyncTransaction(this, this.anyClient());
    }

    public AsyncTransaction newTransaction(DgraphProto.TxnContext context) {
        return new AsyncTransaction(this, this.anyClient(), context);
    }

    public AsyncTransaction newReadOnlyTransaction() {
        return new AsyncTransaction(this, this.anyClient(), true);
    }

    public AsyncTransaction newReadOnlyTransaction(DgraphProto.TxnContext context) {
        return new AsyncTransaction(this, this.anyClient(), context, true);
    }
}

