/*
 * Decompiled with CFR 0.152.
 */
package io.dgraph;

import io.dgraph.DgraphAsyncClient;
import io.dgraph.DgraphException;
import io.dgraph.DgraphGrpc;
import io.dgraph.DgraphProto;
import io.dgraph.StreamObserverBridge;
import io.dgraph.TxnFinishedException;
import io.dgraph.TxnReadOnlyException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AsyncTransaction
implements AutoCloseable {
    private volatile DgraphProto.TxnContext context = DgraphProto.TxnContext.newBuilder().build();
    private volatile boolean mutated;
    private volatile boolean finished;
    private volatile boolean readOnly;
    private volatile boolean bestEffort;
    private final DgraphAsyncClient client;
    private final DgraphGrpc.DgraphStub stub;

    AsyncTransaction(DgraphAsyncClient client, DgraphGrpc.DgraphStub stub) {
        this.client = client;
        this.stub = stub;
        this.readOnly = false;
        this.bestEffort = false;
    }

    AsyncTransaction(DgraphAsyncClient client, DgraphGrpc.DgraphStub stub, boolean readOnly) {
        this(client, stub);
        this.readOnly = readOnly;
    }

    AsyncTransaction(DgraphAsyncClient client, DgraphGrpc.DgraphStub stub, DgraphProto.TxnContext context) {
        this(client, stub);
        this.context = context;
    }

    AsyncTransaction(DgraphAsyncClient client, DgraphGrpc.DgraphStub stub, DgraphProto.TxnContext context, boolean readOnly) {
        this(client, stub, context);
        this.context = context;
        this.readOnly = readOnly;
    }

    public CompletableFuture<DgraphProto.Response> queryWithVars(String query, Map<String, String> vars) {
        DgraphProto.Request request = DgraphProto.Request.newBuilder().setQuery(query).putAllVars(vars).setStartTs(this.context.getStartTs()).setReadOnly(this.readOnly).setBestEffort(this.bestEffort).build();
        return this.doRequest(request);
    }

    public CompletableFuture<DgraphProto.Response> query(String query) {
        return this.queryWithVars(query, Collections.emptyMap());
    }

    public CompletableFuture<DgraphProto.Response> queryRDFWithVars(String query, Map<String, String> vars) {
        DgraphProto.Request request = DgraphProto.Request.newBuilder().setQuery(query).putAllVars(vars).setStartTs(this.context.getStartTs()).setReadOnly(this.readOnly).setBestEffort(this.bestEffort).setRespFormat(DgraphProto.Request.RespFormat.RDF).build();
        return this.doRequest(request);
    }

    public CompletableFuture<DgraphProto.Response> queryRDF(String query) {
        return this.queryRDFWithVars(query, Collections.emptyMap());
    }

    public void setBestEffort(boolean bestEffort) {
        if (!this.readOnly) {
            throw new RuntimeException("Best effort only works for read-only queries");
        }
        this.bestEffort = bestEffort;
    }

    public CompletableFuture<DgraphProto.Response> mutate(DgraphProto.Mutation mutation) {
        DgraphProto.Request request = DgraphProto.Request.newBuilder().addMutations(mutation).setCommitNow(mutation.getCommitNow()).setStartTs(this.context.getStartTs()).build();
        return this.doRequest(request);
    }

    public CompletableFuture<DgraphProto.Response> doRequest(DgraphProto.Request request) {
        if (this.finished) {
            throw new TxnFinishedException();
        }
        if (request.getMutationsCount() > 0) {
            if (this.readOnly) {
                throw new TxnReadOnlyException();
            }
            this.mutated = true;
        }
        DgraphProto.Request requestStartTs = DgraphProto.Request.newBuilder(request).setStartTs(this.context.getStartTs()).setHash(this.context.getHash()).build();
        return this.client.runWithRetries("doRequest", () -> {
            StreamObserverBridge<DgraphProto.Response> bridge = new StreamObserverBridge<DgraphProto.Response>();
            DgraphGrpc.DgraphStub localStub = this.client.getStubWithJwt(this.stub);
            localStub.query(requestStartTs, bridge);
            return bridge.getDelegate().thenApply(response -> {
                if (requestStartTs.getCommitNow()) {
                    this.finished = true;
                }
                this.mergeContext(response.getTxn());
                return response;
            });
        }).handle((response, throwable) -> {
            if (throwable != null) {
                this.discard();
                throw new RuntimeException((Throwable)throwable);
            }
            return response;
        });
    }

    public CompletableFuture<Void> commit() {
        if (this.readOnly) {
            throw new TxnReadOnlyException();
        }
        if (this.finished) {
            throw new TxnFinishedException();
        }
        this.finished = true;
        if (!this.mutated) {
            return CompletableFuture.completedFuture(null);
        }
        return this.client.runWithRetries("commit", () -> {
            StreamObserverBridge<DgraphProto.TxnContext> bridge = new StreamObserverBridge<DgraphProto.TxnContext>();
            DgraphGrpc.DgraphStub localStub = this.client.getStubWithJwt(this.stub);
            localStub.commitOrAbort(this.context, bridge);
            return bridge.getDelegate().thenApply(txnContext -> null);
        });
    }

    public CompletableFuture<Void> discard() {
        if (this.finished) {
            return CompletableFuture.completedFuture(null);
        }
        this.finished = true;
        if (!this.mutated) {
            return CompletableFuture.completedFuture(null);
        }
        this.context = DgraphProto.TxnContext.newBuilder(this.context).setAborted(true).build();
        return this.client.runWithRetries("discard", () -> {
            StreamObserverBridge<DgraphProto.TxnContext> bridge = new StreamObserverBridge<DgraphProto.TxnContext>();
            DgraphGrpc.DgraphStub localStub = this.client.getStubWithJwt(this.stub);
            localStub.commitOrAbort(this.context, bridge);
            return bridge.getDelegate().thenApply(o -> null);
        });
    }

    private void mergeContext(DgraphProto.TxnContext src) {
        DgraphProto.TxnContext.Builder builder = DgraphProto.TxnContext.newBuilder(this.context);
        builder.setHash(src.getHash());
        if (this.context.getStartTs() == 0L) {
            builder.setStartTs(src.getStartTs());
        } else if (this.context.getStartTs() != src.getStartTs()) {
            this.context = builder.build();
            throw new DgraphException("startTs mismatch");
        }
        builder.addAllKeys((Iterable<String>)src.getKeysList());
        builder.addAllPreds((Iterable<String>)src.getPredsList());
        this.context = builder.build();
    }

    @Override
    public void close() {
        this.discard().join();
    }
}

