/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event.deserialization;

import com.github.shyiko.mysql.binlog.event.GtidEventData;
import com.github.shyiko.mysql.binlog.event.MySqlGtid;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.UUID;

public class GtidEventDataDeserializer
implements EventDataDeserializer<GtidEventData> {
    public static final int LOGICAL_TIMESTAMP_TYPECODE_LENGTH = 1;
    public static final int LOGICAL_TIMESTAMP_TYPECODE = 2;
    public static final int LOGICAL_TIMESTAMP_LENGTH = 8;
    public static final int IMMEDIATE_COMMIT_TIMESTAMP_LENGTH = 7;
    public static final int ORIGINAL_COMMIT_TIMESTAMP_LENGTH = 7;
    public static final int ENCODED_COMMIT_TIMESTAMP_LENGTH = 55;
    public static final int TRANSACTION_LENGTH_MIN_LENGTH = 1;
    public static final int IMMEDIATE_SERVER_VERSION_LENGTH = 4;
    public static final int ORIGINAL_SERVER_VERSION_LENGTH = 4;
    public static final int ENCODED_SERVER_VERSION_LENGTH = 31;
    public static final int UNDEFINED_SERVER_VERSION = 999999;

    @Override
    public GtidEventData deserialize(ByteArrayInputStream inputStream) throws IOException {
        byte flags = (byte)inputStream.readInteger(1);
        long sourceIdMostSignificantBits = GtidEventDataDeserializer.readLongBigEndian(inputStream);
        long sourceIdLeastSignificantBits = GtidEventDataDeserializer.readLongBigEndian(inputStream);
        long transactionId = inputStream.readLong(8);
        MySqlGtid gtid = new MySqlGtid(new UUID(sourceIdMostSignificantBits, sourceIdLeastSignificantBits), transactionId);
        long lastCommitted = 0L;
        long sequenceNumber = 0L;
        long immediateCommitTimestamp = 0L;
        long originalCommitTimestamp = 0L;
        long transactionLength = 0L;
        int immediateServerVersion = 0;
        int originalServerVersion = 0;
        if (inputStream.peek() == 2) {
            inputStream.skip(1L);
            lastCommitted = inputStream.readLong(8);
            sequenceNumber = inputStream.readLong(8);
            if (inputStream.available() >= 7) {
                immediateCommitTimestamp = inputStream.readLong(7);
                if ((immediateCommitTimestamp & 0x80000000000000L) != 0L) {
                    immediateCommitTimestamp &= 0xFF7FFFFFFFFFFFFFL;
                    originalCommitTimestamp = inputStream.readLong(7);
                } else {
                    originalCommitTimestamp = immediateCommitTimestamp;
                }
                if (inputStream.available() >= 1) {
                    transactionLength = inputStream.readPackedLong();
                }
                immediateServerVersion = 999999;
                originalServerVersion = 999999;
                if (inputStream.available() >= 4) {
                    immediateServerVersion = inputStream.readInteger(4);
                    if (((long)immediateServerVersion & 0x80000000L) != 0L) {
                        immediateServerVersion = (int)((long)immediateServerVersion & 0xFFFFFFFF7FFFFFFFL);
                        originalServerVersion = inputStream.readInteger(4);
                    } else {
                        originalServerVersion = immediateServerVersion;
                    }
                }
            }
        }
        return new GtidEventData(gtid, flags, lastCommitted, sequenceNumber, immediateCommitTimestamp, originalCommitTimestamp, transactionLength, immediateServerVersion, originalServerVersion);
    }

    private static long readLongBigEndian(ByteArrayInputStream input) throws IOException {
        long result = 0L;
        int i = 0;
        while (i < 8) {
            result = result << 8 | (long)(input.read() & 0xFF);
            ++i;
        }
        return result;
    }
}

