/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event.deserialization;

import com.github.shyiko.mysql.binlog.event.EventData;
import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.ColumnType;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.MissingTableMapEventException;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;

public abstract class AbstractRowsEventDataDeserializer<T extends EventData>
implements EventDataDeserializer<T> {
    private static final int DIG_PER_DEC = 9;
    private static final int[] DIG_TO_BYTES;
    private final Map<Long, TableMapEventData> tableMapEventByTableId;
    private boolean deserializeDateAndTimeAsLong;
    private Long invalidDateAndTimeRepresentation;
    private boolean microsecondsPrecision;
    private boolean deserializeCharAndBinaryAsByteArray;
    private boolean deserializeIntegerAsByteArray;

    static {
        int[] nArray = new int[10];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 2;
        nArray[5] = 3;
        nArray[6] = 3;
        nArray[7] = 4;
        nArray[8] = 4;
        nArray[9] = 4;
        DIG_TO_BYTES = nArray;
    }

    public AbstractRowsEventDataDeserializer(Map<Long, TableMapEventData> tableMapEventByTableId) {
        this.tableMapEventByTableId = tableMapEventByTableId;
    }

    void setDeserializeDateAndTimeAsLong(boolean value) {
        this.deserializeDateAndTimeAsLong = value;
    }

    void setInvalidDateAndTimeRepresentation(Long value) {
        this.invalidDateAndTimeRepresentation = value;
    }

    void setMicrosecondsPrecision(boolean value) {
        this.microsecondsPrecision = value;
    }

    void setDeserializeCharAndBinaryAsByteArray(boolean value) {
        this.deserializeCharAndBinaryAsByteArray = value;
    }

    void setDeserializeIntegerAsByteArray(boolean deserializeIntegerAsByteArray) {
        this.deserializeIntegerAsByteArray = deserializeIntegerAsByteArray;
    }

    protected Serializable[] deserializeRow(long tableId, BitSet includedColumns, ByteArrayInputStream inputStream) throws IOException {
        TableMapEventData tableMapEvent = this.tableMapEventByTableId.get(tableId);
        if (tableMapEvent == null) {
            throw new MissingTableMapEventException("No TableMapEventData has been found for table id:" + tableId + ". Usually that means that you have started reading binary log 'within the logical event group'" + " (e.g. from WRITE_ROWS and not proceeding TABLE_MAP");
        }
        byte[] types = tableMapEvent.getColumnTypes();
        int[] metadata = tableMapEvent.getColumnMetadata();
        Serializable[] result = new Serializable[AbstractRowsEventDataDeserializer.numberOfBitsSet(includedColumns)];
        BitSet nullColumns = inputStream.readBitSet(result.length, true);
        int i = 0;
        int numberOfSkippedColumns = 0;
        while (i < types.length) {
            if (!includedColumns.get(i)) {
                ++numberOfSkippedColumns;
            } else {
                int index = i - numberOfSkippedColumns;
                if (!nullColumns.get(index)) {
                    int typeCode = types[i] & 0xFF;
                    int meta = metadata[i];
                    int length = 0;
                    if (typeCode == ColumnType.STRING.getCode()) {
                        if (meta >= 256) {
                            int meta0 = meta >> 8;
                            int meta1 = meta & 0xFF;
                            if ((meta0 & 0x30) != 48) {
                                typeCode = meta0 | 0x30;
                                length = meta1 | (meta0 & 0x30 ^ 0x30) << 4;
                            } else {
                                if (meta0 == ColumnType.ENUM.getCode() || meta0 == ColumnType.SET.getCode()) {
                                    typeCode = meta0;
                                }
                                length = meta1;
                            }
                        } else {
                            length = meta;
                        }
                    }
                    result[index] = this.deserializeCell(ColumnType.byCode(typeCode), meta, length, inputStream);
                }
            }
            ++i;
        }
        return result;
    }

    protected Serializable deserializeCell(ColumnType type, int meta, int length, ByteArrayInputStream inputStream) throws IOException {
        switch (type) {
            case BIT: {
                return this.deserializeBit(meta, inputStream);
            }
            case TINY: {
                return this.deserializeTiny(inputStream);
            }
            case SHORT: {
                return this.deserializeShort(inputStream);
            }
            case INT24: {
                return this.deserializeInt24(inputStream);
            }
            case LONG: {
                return this.deserializeLong(inputStream);
            }
            case LONGLONG: {
                return this.deserializeLongLong(inputStream);
            }
            case FLOAT: {
                return this.deserializeFloat(inputStream);
            }
            case DOUBLE: {
                return this.deserializeDouble(inputStream);
            }
            case NEWDECIMAL: {
                return this.deserializeNewDecimal(meta, inputStream);
            }
            case DATE: {
                return this.deserializeDate(inputStream);
            }
            case TIME: {
                return this.deserializeTime(inputStream);
            }
            case TIME_V2: {
                return this.deserializeTimeV2(meta, inputStream);
            }
            case TIMESTAMP: {
                return this.deserializeTimestamp(inputStream);
            }
            case TIMESTAMP_V2: {
                return this.deserializeTimestampV2(meta, inputStream);
            }
            case DATETIME: {
                return this.deserializeDatetime(inputStream);
            }
            case DATETIME_V2: {
                return this.deserializeDatetimeV2(meta, inputStream);
            }
            case YEAR: {
                return this.deserializeYear(inputStream);
            }
            case STRING: {
                return this.deserializeString(length, inputStream);
            }
            case VARCHAR: 
            case VAR_STRING: {
                return this.deserializeVarString(meta, inputStream);
            }
            case BLOB: {
                return this.deserializeBlob(meta, inputStream);
            }
            case ENUM: {
                return this.deserializeEnum(length, inputStream);
            }
            case SET: {
                return this.deserializeSet(length, inputStream);
            }
            case GEOMETRY: {
                return this.deserializeGeometry(meta, inputStream);
            }
            case JSON: {
                return this.deserializeJson(meta, inputStream);
            }
            case VECTOR: {
                return this.deserializeVector(meta, inputStream);
            }
        }
        throw new IOException("Unsupported type " + (Object)((Object)type));
    }

    protected Serializable deserializeBit(int meta, ByteArrayInputStream inputStream) throws IOException {
        int bitSetLength = (meta >> 8) * 8 + (meta & 0xFF);
        return inputStream.readBitSet(bitSetLength, false);
    }

    protected Serializable deserializeTiny(ByteArrayInputStream inputStream) throws IOException {
        if (this.deserializeIntegerAsByteArray) {
            return inputStream.read(1);
        }
        return Integer.valueOf((byte)inputStream.readInteger(1));
    }

    protected Serializable deserializeShort(ByteArrayInputStream inputStream) throws IOException {
        if (this.deserializeIntegerAsByteArray) {
            return inputStream.read(2);
        }
        return Integer.valueOf((short)inputStream.readInteger(2));
    }

    protected Serializable deserializeInt24(ByteArrayInputStream inputStream) throws IOException {
        if (this.deserializeIntegerAsByteArray) {
            return inputStream.read(3);
        }
        return Integer.valueOf(inputStream.readInteger(3) << 8 >> 8);
    }

    protected Serializable deserializeLong(ByteArrayInputStream inputStream) throws IOException {
        if (this.deserializeIntegerAsByteArray) {
            return inputStream.read(4);
        }
        return Integer.valueOf(inputStream.readInteger(4));
    }

    protected Serializable deserializeLongLong(ByteArrayInputStream inputStream) throws IOException {
        if (this.deserializeIntegerAsByteArray) {
            return inputStream.read(8);
        }
        return Long.valueOf(inputStream.readLong(8));
    }

    protected Serializable deserializeFloat(ByteArrayInputStream inputStream) throws IOException {
        return Float.valueOf(Float.intBitsToFloat(inputStream.readInteger(4)));
    }

    protected Serializable deserializeDouble(ByteArrayInputStream inputStream) throws IOException {
        return Double.valueOf(Double.longBitsToDouble(inputStream.readLong(8)));
    }

    protected Serializable deserializeNewDecimal(int meta, ByteArrayInputStream inputStream) throws IOException {
        int precision = meta & 0xFF;
        int scale = meta >> 8;
        int x = precision - scale;
        int ipd = x / 9;
        int fpd = scale / 9;
        int decimalLength = (ipd << 2) + DIG_TO_BYTES[x - ipd * 9] + (fpd << 2) + DIG_TO_BYTES[scale - fpd * 9];
        return AbstractRowsEventDataDeserializer.asBigDecimal(precision, scale, inputStream.read(decimalLength));
    }

    private Long castTimestamp(Long timestamp, int fsp) {
        if (this.microsecondsPrecision && timestamp != null && !timestamp.equals(this.invalidDateAndTimeRepresentation)) {
            return timestamp * 1000L + (long)(fsp % 1000);
        }
        return timestamp;
    }

    protected Serializable deserializeDate(ByteArrayInputStream inputStream) throws IOException {
        int value = inputStream.readInteger(3);
        int day = value % 32;
        int month = (value >>>= 5) % 16;
        int year = value >> 4;
        Long timestamp = this.asUnixTime(year, month, day, 0, 0, 0, 0);
        if (this.deserializeDateAndTimeAsLong) {
            return this.castTimestamp(timestamp, 0);
        }
        return timestamp != null ? new Date(timestamp) : null;
    }

    protected Serializable deserializeTime(ByteArrayInputStream inputStream) throws IOException {
        int value = inputStream.readInteger(3);
        int[] split = AbstractRowsEventDataDeserializer.split(value, 100, 3);
        Long timestamp = this.asUnixTime(1970, 1, 1, split[2], split[1], split[0], 0);
        if (this.deserializeDateAndTimeAsLong) {
            return this.castTimestamp(timestamp, 0);
        }
        return timestamp != null ? new Time(timestamp) : null;
    }

    protected Serializable deserializeTimeV2(int meta, ByteArrayInputStream inputStream) throws IOException {
        long time = AbstractRowsEventDataDeserializer.bigEndianLong(inputStream.read(3), 0, 3);
        int fsp = this.deserializeFractionalSeconds(meta, inputStream);
        Long timestamp = this.asUnixTime(1970, 1, 1, AbstractRowsEventDataDeserializer.bitSlice(time, 2, 10, 24), AbstractRowsEventDataDeserializer.bitSlice(time, 12, 6, 24), AbstractRowsEventDataDeserializer.bitSlice(time, 18, 6, 24), fsp / 1000);
        if (this.deserializeDateAndTimeAsLong) {
            return this.castTimestamp(timestamp, fsp);
        }
        return timestamp != null ? new Time(timestamp) : null;
    }

    protected Serializable deserializeTimestamp(ByteArrayInputStream inputStream) throws IOException {
        long timestamp = inputStream.readLong(4) * 1000L;
        if (this.deserializeDateAndTimeAsLong) {
            return this.castTimestamp(timestamp, 0);
        }
        return new Timestamp(timestamp);
    }

    protected Serializable deserializeTimestampV2(int meta, ByteArrayInputStream inputStream) throws IOException {
        long millis = AbstractRowsEventDataDeserializer.bigEndianLong(inputStream.read(4), 0, 4);
        int fsp = this.deserializeFractionalSeconds(meta, inputStream);
        long timestamp = millis * 1000L + (long)(fsp / 1000);
        if (this.deserializeDateAndTimeAsLong) {
            return this.castTimestamp(timestamp, fsp);
        }
        return new Timestamp(timestamp);
    }

    protected Serializable deserializeDatetime(ByteArrayInputStream inputStream) throws IOException {
        int[] split = AbstractRowsEventDataDeserializer.split(inputStream.readLong(8), 100, 6);
        Long timestamp = this.asUnixTime(split[5], split[4], split[3], split[2], split[1], split[0], 0);
        if (this.deserializeDateAndTimeAsLong) {
            return this.castTimestamp(timestamp, 0);
        }
        return timestamp != null ? new java.util.Date(timestamp) : null;
    }

    protected Serializable deserializeDatetimeV2(int meta, ByteArrayInputStream inputStream) throws IOException {
        long datetime = AbstractRowsEventDataDeserializer.bigEndianLong(inputStream.read(5), 0, 5);
        int yearMonth = AbstractRowsEventDataDeserializer.bitSlice(datetime, 1, 17, 40);
        int fsp = this.deserializeFractionalSeconds(meta, inputStream);
        Long timestamp = this.asUnixTime(yearMonth / 13, yearMonth % 13, AbstractRowsEventDataDeserializer.bitSlice(datetime, 18, 5, 40), AbstractRowsEventDataDeserializer.bitSlice(datetime, 23, 5, 40), AbstractRowsEventDataDeserializer.bitSlice(datetime, 28, 6, 40), AbstractRowsEventDataDeserializer.bitSlice(datetime, 34, 6, 40), fsp / 1000);
        if (this.deserializeDateAndTimeAsLong) {
            return this.castTimestamp(timestamp, fsp);
        }
        return timestamp != null ? new java.util.Date(timestamp) : null;
    }

    protected Serializable deserializeYear(ByteArrayInputStream inputStream) throws IOException {
        return Integer.valueOf(1900 + inputStream.readInteger(1));
    }

    protected Serializable deserializeString(int length, ByteArrayInputStream inputStream) throws IOException {
        int stringLength;
        int n = stringLength = length < 256 ? inputStream.readInteger(1) : inputStream.readInteger(2);
        if (this.deserializeCharAndBinaryAsByteArray) {
            return inputStream.read(stringLength);
        }
        return inputStream.readString(stringLength);
    }

    protected Serializable deserializeVarString(int meta, ByteArrayInputStream inputStream) throws IOException {
        int varcharLength;
        int n = varcharLength = meta < 256 ? inputStream.readInteger(1) : inputStream.readInteger(2);
        if (this.deserializeCharAndBinaryAsByteArray) {
            return inputStream.read(varcharLength);
        }
        return inputStream.readString(varcharLength);
    }

    protected Serializable deserializeBlob(int meta, ByteArrayInputStream inputStream) throws IOException {
        int blobLength = inputStream.readInteger(meta);
        return inputStream.read(blobLength);
    }

    protected Serializable deserializeVector(int meta, ByteArrayInputStream inputStream) throws IOException {
        int vectorLength = inputStream.readInteger(meta);
        return inputStream.read(vectorLength);
    }

    protected Serializable deserializeEnum(int length, ByteArrayInputStream inputStream) throws IOException {
        return Integer.valueOf(inputStream.readInteger(length));
    }

    protected Serializable deserializeSet(int length, ByteArrayInputStream inputStream) throws IOException {
        return Long.valueOf(inputStream.readLong(length));
    }

    protected Serializable deserializeGeometry(int meta, ByteArrayInputStream inputStream) throws IOException {
        int dataLength = inputStream.readInteger(meta);
        return inputStream.read(dataLength);
    }

    protected byte[] deserializeJson(int meta, ByteArrayInputStream inputStream) throws IOException {
        int blobLength = inputStream.readInteger(meta);
        return inputStream.read(blobLength);
    }

    protected Long asUnixTime(int year, int month, int day, int hour, int minute, int second, int millis) {
        if (year == 0 || month == 0 || day == 0) {
            return this.invalidDateAndTimeRepresentation;
        }
        return UnixTime.from(year, month, day, hour, minute, second, millis);
    }

    protected int deserializeFractionalSeconds(int meta, ByteArrayInputStream inputStream) throws IOException {
        int length = (meta + 1) / 2;
        if (length > 0) {
            int fraction = AbstractRowsEventDataDeserializer.bigEndianInteger(inputStream.read(length), 0, length);
            return fraction * (int)Math.pow(100.0, 3 - length);
        }
        return 0;
    }

    private static int bitSlice(long value, int bitOffset, int numberOfBits, int payloadSize) {
        long result = value >> payloadSize - (bitOffset + numberOfBits);
        return (int)(result & (long)((1 << numberOfBits) - 1));
    }

    private static int numberOfBitsSet(BitSet bitSet) {
        int result = 0;
        int i = bitSet.nextSetBit(0);
        while (i >= 0) {
            ++result;
            i = bitSet.nextSetBit(i + 1);
        }
        return result;
    }

    private static int[] split(long value, int divider, int length) {
        int[] result = new int[length];
        int i = 0;
        while (i < length - 1) {
            result[i] = (int)(value % (long)divider);
            value /= (long)divider;
            ++i;
        }
        result[length - 1] = (int)value;
        return result;
    }

    public static BigDecimal asBigDecimal(int precision, int scale, byte[] value) {
        int i;
        boolean positive = (value[0] & 0x80) == 128;
        value[0] = (byte)(value[0] ^ 0x80);
        if (!positive) {
            int i2 = 0;
            while (i2 < value.length) {
                int n = i2++;
                value[n] = (byte)(value[n] ^ 0xFF);
            }
        }
        int x = precision - scale;
        int ipDigits = x / 9;
        int ipDigitsX = x - ipDigits * 9;
        int ipSize = (ipDigits << 2) + DIG_TO_BYTES[ipDigitsX];
        int offset = DIG_TO_BYTES[ipDigitsX];
        BigDecimal ip = offset > 0 ? BigDecimal.valueOf(AbstractRowsEventDataDeserializer.bigEndianInteger(value, 0, offset)) : BigDecimal.ZERO;
        while (offset < ipSize) {
            int i3 = AbstractRowsEventDataDeserializer.bigEndianInteger(value, offset, 4);
            ip = ip.movePointRight(9).add(BigDecimal.valueOf(i3));
            offset += 4;
        }
        int shift = 0;
        BigDecimal fp = BigDecimal.ZERO;
        while (shift + 9 <= scale) {
            i = AbstractRowsEventDataDeserializer.bigEndianInteger(value, offset, 4);
            fp = fp.add(BigDecimal.valueOf(i).movePointLeft(shift + 9));
            shift += 9;
            offset += 4;
        }
        if (shift < scale) {
            i = AbstractRowsEventDataDeserializer.bigEndianInteger(value, offset, DIG_TO_BYTES[scale - shift]);
            fp = fp.add(BigDecimal.valueOf(i).movePointLeft(scale));
        }
        BigDecimal result = ip.add(fp);
        return positive ? result : result.negate();
    }

    private static int bigEndianInteger(byte[] bytes, int offset, int length) {
        int result = 0;
        int i = offset;
        while (i < offset + length) {
            int b = bytes[i];
            result = result << 8 | (b >= 0 ? b : b + 256);
            ++i;
        }
        return result;
    }

    private static long bigEndianLong(byte[] bytes, int offset, int length) {
        long result = 0L;
        int i = offset;
        while (i < offset + length) {
            int b = bytes[i];
            result = result << 8 | (long)(b >= 0 ? b : b + 256);
            ++i;
        }
        return result;
    }

    static class UnixTime {
        private static final int[] YEAR_DAYS_BY_MONTH;
        private static final int[] LEAP_YEAR_DAYS_BY_MONTH;

        static {
            int[] nArray = new int[13];
            nArray[1] = 31;
            nArray[2] = 59;
            nArray[3] = 90;
            nArray[4] = 120;
            nArray[5] = 151;
            nArray[6] = 181;
            nArray[7] = 212;
            nArray[8] = 243;
            nArray[9] = 273;
            nArray[10] = 304;
            nArray[11] = 334;
            nArray[12] = 365;
            YEAR_DAYS_BY_MONTH = nArray;
            int[] nArray2 = new int[13];
            nArray2[1] = 31;
            nArray2[2] = 60;
            nArray2[3] = 91;
            nArray2[4] = 121;
            nArray2[5] = 152;
            nArray2[6] = 182;
            nArray2[7] = 213;
            nArray2[8] = 244;
            nArray2[9] = 274;
            nArray2[10] = 305;
            nArray2[11] = 335;
            nArray2[12] = 366;
            LEAP_YEAR_DAYS_BY_MONTH = nArray2;
        }

        UnixTime() {
        }

        public static long from(int year, int month, int day, int hour, int minute, int second, int millis) {
            if (year < 1582 || year == 1582 && (month < 10 || month == 10 && day < 15)) {
                return UnixTime.fallbackToGC(year, month, day, hour, minute, second, millis);
            }
            long timestamp = 0L;
            int numberOfLeapYears = UnixTime.leapYears(1970, year);
            timestamp += 31622400L * (long)numberOfLeapYears;
            timestamp += 31536000L * (long)(year - 1970 - numberOfLeapYears);
            long daysUpToMonth = UnixTime.isLeapYear(year) ? LEAP_YEAR_DAYS_BY_MONTH[month - 1] : YEAR_DAYS_BY_MONTH[month - 1];
            timestamp += (daysUpToMonth + (long)day - 1L) * 24L * 60L * 60L + (long)(hour * 60 * 60) + (long)(minute * 60) + (long)second;
            timestamp = timestamp * 1000L + (long)millis;
            return timestamp;
        }

        private static long fallbackToGC(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second, int millis) {
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            c.set(1, year);
            c.set(2, month - 1);
            c.set(5, dayOfMonth);
            c.set(11, hourOfDay);
            c.set(12, minute);
            c.set(13, second);
            c.set(14, millis);
            return c.getTimeInMillis();
        }

        private static int leapYears(int from, int end) {
            return UnixTime.leapYearsBefore(end) - UnixTime.leapYearsBefore(from + 1);
        }

        private static int leapYearsBefore(int year) {
            return --year / 4 - year / 100 + year / 400;
        }

        private static boolean isLeapYear(int year) {
            return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        }
    }
}

