/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.htmladapter.base.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jackson.JsonNodeReader;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import ink.rayin.htmladapter.base.utils.CodeMessage;
import ink.rayin.htmladapter.base.utils.RayinException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaValidator {
    private static Logger logger = LoggerFactory.getLogger(JsonSchemaValidator.class);

    public static void validateJsonByFgeByJsonNode(JsonNode jsonNode, JsonNode schemaNode) {
        HashMap result = new HashMap();
        ProcessingReport report = null;
        report = JsonSchemaFactory.byDefault().getValidator().validateUnchecked(schemaNode, jsonNode);
        if (!report.isSuccess()) {
            Iterator it = report.iterator();
            String ms = "";
            while (it.hasNext()) {
                ProcessingMessage pm = (ProcessingMessage)it.next();
                if (LogLevel.WARNING.equals((Object)pm.getLogLevel())) continue;
                ms = ms + pm;
            }
            logger.error("\u6821\u9a8c\u5931\u8d25\uff01" + ms);
            throw new RayinException(CodeMessage.DATA_FORMAT_ERROR, ms, null);
        }
    }

    public static JsonNode getJsonNodeFromString(String jsonStr) {
        JsonNode jsonNode = null;
        try {
            jsonNode = JsonLoader.fromString((String)jsonStr);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RayinException("\u6a21\u677f\u914d\u7f6e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u786e\u8ba4\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff01");
        }
        return jsonNode;
    }

    public static JsonNode getJsonNodeFromFile(String filePath) {
        JsonNode jsonNode = null;
        try {
            jsonNode = new JsonNodeReader().fromReader((Reader)new FileReader(filePath));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jsonNode;
    }

    public static JsonNode getJsonNodeFromInputStream(InputStream is) {
        JsonNode jsonNode = null;
        try {
            jsonNode = new JsonNodeReader().fromInputStream(is);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jsonNode;
    }
}

