/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.htmladapter.base.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;

public class HttpURLConnHelper {
    public static BufferedInputStream loadFileFromURL(String urlString) {
        BufferedInputStream bis = null;
        HttpURLConnection httpConn = null;
        try {
            URL urlObj = new URL(urlString);
            httpConn = (HttpURLConnection)urlObj.openConnection();
            httpConn.setDoInput(true);
            httpConn.setRequestMethod("GET");
            httpConn.setConnectTimeout(5000);
            httpConn.connect();
            if (httpConn.getResponseCode() == 200) {
                bis = new BufferedInputStream(httpConn.getInputStream());
                return bis;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadByteFromURL(String url) {
        HttpURLConnection httpConn = null;
        BufferedInputStream bis = null;
        try {
            URL urlObj = new URL(url);
            httpConn = (HttpURLConnection)urlObj.openConnection();
            httpConn.setRequestMethod("GET");
            httpConn.setDoInput(true);
            httpConn.setConnectTimeout(5000);
            httpConn.connect();
            if (httpConn.getResponseCode() == 200) {
                bis = new BufferedInputStream(httpConn.getInputStream());
                byte[] byArray = HttpURLConnHelper.streamToByte(bis);
                return byArray;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                httpConn.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFileFromURL(String url, File destFile) {
        HttpURLConnection httpConn = null;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(destFile));
            URL urlObj = new URL(url);
            httpConn = (HttpURLConnection)urlObj.openConnection();
            httpConn.setRequestMethod("GET");
            httpConn.setDoInput(true);
            httpConn.setConnectTimeout(5000);
            httpConn.connect();
            if (httpConn.getResponseCode() == 200) {
                bis = new BufferedInputStream(httpConn.getInputStream());
                int c = 0;
                byte[] buffer = new byte[8192];
                while ((c = bis.read(buffer)) != -1) {
                    bos.write(buffer, 0, c);
                    bos.flush();
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (bos != null) {
                    bos.close();
                }
                httpConn.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] doPostSubmit(String url, String params) {
        FilterOutputStream bos = null;
        BufferedInputStream bis = null;
        HttpURLConnection httpConn = null;
        try {
            URL urlObj = new URL(url);
            httpConn = (HttpURLConnection)urlObj.openConnection();
            httpConn.setDoInput(true);
            httpConn.setDoOutput(true);
            httpConn.setRequestMethod("POST");
            httpConn.setConnectTimeout(5000);
            if (params != null) {
                byte[] data = params.getBytes();
                bos = new BufferedOutputStream(httpConn.getOutputStream());
                bos.write(data);
                ((BufferedOutputStream)bos).flush();
            }
            if (httpConn.getResponseCode() == 200) {
                bis = new BufferedInputStream(httpConn.getInputStream());
                byte[] byArray = HttpURLConnHelper.streamToByte(bis);
                return byArray;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (bos != null) {
                    bos.close();
                }
                httpConn.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostSubmitBody(String url, Map<String, String> map, String filePath, byte[] body_data, String charset) {
        String NEWLINE = "\r\n";
        String PREFIX = "--";
        String BOUNDARY = "#";
        HttpURLConnection httpConn = null;
        BufferedInputStream bis = null;
        FilterOutputStream dos = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            URL urlObj = new URL(url);
            httpConn = (HttpURLConnection)urlObj.openConnection();
            httpConn.setDoInput(true);
            httpConn.setDoOutput(true);
            httpConn.setRequestMethod("POST");
            httpConn.setUseCaches(false);
            httpConn.setRequestProperty("Connection", "Keep-Alive");
            httpConn.setRequestProperty("Accept", "*/*");
            httpConn.setRequestProperty("Accept-Encoding", "gzip, deflate");
            httpConn.setRequestProperty("Cache-Control", "no-cache");
            httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=#");
            httpConn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 2.0.50727; .NET CLR 3.0.04506.30)");
            httpConn.connect();
            dos = new DataOutputStream(httpConn.getOutputStream());
            if (map != null && !map.isEmpty()) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String key = entry.getKey();
                    String value = map.get(key);
                    ((DataOutputStream)dos).writeBytes("--#\r\n");
                    ((DataOutputStream)dos).writeBytes("Content-Disposition: form-data; name=\"" + key + "\"" + "\r\n");
                    ((DataOutputStream)dos).writeBytes("\r\n");
                    ((DataOutputStream)dos).writeBytes(URLEncoder.encode(value.toString(), charset));
                    ((DataOutputStream)dos).writeBytes("\r\n");
                }
            }
            if (body_data != null && body_data.length > 0) {
                ((DataOutputStream)dos).writeBytes("--#\r\n");
                String fileName = filePath.substring(filePath.lastIndexOf(File.separatorChar) + 1);
                ((DataOutputStream)dos).writeBytes("Content-Disposition: form-data; name=\"uploadFile\"; filename=\"" + fileName + "\"" + "\r\n");
                ((DataOutputStream)dos).writeBytes("\r\n");
                dos.write(body_data);
                ((DataOutputStream)dos).writeBytes("\r\n");
            }
            ((DataOutputStream)dos).writeBytes("--#--\r\n");
            ((DataOutputStream)dos).flush();
            byte[] buffer = new byte[8192];
            int c = 0;
            if (httpConn.getResponseCode() == 200) {
                bis = new BufferedInputStream(httpConn.getInputStream());
                while ((c = bis.read(buffer)) != -1) {
                    baos.write(buffer, 0, c);
                    baos.flush();
                }
            }
            String string = new String(baos.toByteArray(), charset);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
                if (bis != null) {
                    bis.close();
                }
                if (baos != null) {
                    baos.close();
                }
                httpConn.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] streamToByte(InputStream is) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int c = 0;
        byte[] buffer = new byte[8192];
        try {
            while ((c = is.read(buffer)) != -1) {
                baos.write(buffer, 0, c);
                baos.flush();
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void main(String[] args) {
        String url = "http://10.31.57.110:8008//datafs/fs/test/TPL00285/2018041919/C1D2242518D04E099C6AF3116E1E86B4_M.pdf";
        byte[] iStream = HttpURLConnHelper.loadByteFromURL(url);
    }
}

