/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.htmladapter.base.utils;

public enum CodeMessage {
    SUCCESS(0, "SUCCESS"),
    FAILED(-1, "opertion failed"),
    HTTP_BAD_REQUEST(400, "Request parameter error"),
    HTTP_UNAUTHORIZED(401, "Authentication failed"),
    HTTP_DENIED(403, "Access denied"),
    HTTP_NOT_FOUND(404, "Access to the resource does not exist"),
    HTTP_INTERNAL_SERVER_ERROR(500, "Server internal error, please contact your administrator"),
    HTTP_READ_RESP_ERROR(501, "HTTP read response failed"),
    HTTP_INIT_CLIENT_ERROR(502, "PoolingHttpClientConnectionManager\u521d\u59cb\u5316\u5931\u8d25"),
    DATA_FORMAT_ERROR(1000, "data format error"),
    BIZ_UNKNOWN_ERROR(600, "unexpected error"),
    DATA_RESOLVE_FAIL(1001, "Data parsing errors"),
    OTHERS(99999, "others error");

    private final int code;
    private final String message;

    private CodeMessage(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public static CodeMessage fromCode(int code) {
        for (CodeMessage e : CodeMessage.values()) {
            if (e.getCode() != code) continue;
            return e;
        }
        return BIZ_UNKNOWN_ERROR;
    }

    public String getDescribtion() {
        return "{code:" + this.code + ",message:" + this.message + "}";
    }
}

