/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.htmladapter.base.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import java.util.HashMap;

public class CodeImageUtils {
    public static ByteArrayOutputStream qrCodeImage(String text) throws IOException {
        BitMatrix bitMatrix;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.MARGIN, 0);
        try {
            bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, 300, 300, hints);
        }
        catch (WriterException e) {
            e.printStackTrace();
            return null;
        }
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)bos);
        return bos;
    }

    public static String qrCodeImageBase64(String text) throws IOException {
        Base64.Encoder encoder = Base64.getEncoder();
        ByteArrayOutputStream stream = CodeImageUtils.qrCodeImage(text);
        return encoder.encodeToString(stream.toByteArray());
    }

    public static ByteArrayOutputStream barCodeImage(String text, int width, int height, int angel, BarcodeFormat barcodeFormat) throws IOException, WriterException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, (String)ErrorCorrectionLevel.H);
        MultiFormatWriter writer = new MultiFormatWriter();
        BitMatrix bitMatrix = writer.encode(text, barcodeFormat, width, height, hints);
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)bos);
        return bos;
    }

    private static Rectangle CalcRotatedSize(Rectangle src, int angel) {
        if (angel >= 90) {
            if (angel / 90 % 2 == 1) {
                int temp = src.height;
                src.height = src.width;
                src.width = temp;
            }
            angel %= 90;
        }
        double r = Math.sqrt(src.height * src.height + src.width * src.width) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(angel) / 2.0) * r;
        double angel_alpha = (Math.PI - Math.toRadians(angel)) / 2.0;
        double angel_dalta_width = Math.atan((double)src.height / (double)src.width);
        double angel_dalta_height = Math.atan((double)src.width / (double)src.height);
        int len_dalta_width = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_width));
        int len_dalta_height = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_height));
        int des_width = src.width + len_dalta_width * 2;
        int des_height = src.height + len_dalta_height * 2;
        return new Rectangle(new Dimension(des_width, des_height));
    }

    public static String barCodeImageBase64(String text, int width, int height, int angel, BarcodeFormat barcodeFormat) throws IOException, WriterException {
        Base64.Encoder encoder = Base64.getEncoder();
        ByteArrayOutputStream stream = CodeImageUtils.barCodeImage(text, width, height, angel, barcodeFormat);
        return encoder.encodeToString(stream.toByteArray());
    }
}

