/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.htmladapter.base.utils;

import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACParserCSS3;
import ink.rayin.tools.utils.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.dom.css.CSSPageRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSParser {
    private static final Logger log = LoggerFactory.getLogger(CSSParser.class);

    public static boolean checkCssProperty(String cssStr, String selectorStr, String property) throws IOException {
        InputSource source = new InputSource((Reader)new StringReader(cssStr));
        source.setEncoding("UTF-8");
        CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
        CSSStyleSheet sheet = parser.parseStyleSheet(source, null, null);
        CSSRuleList rules = sheet.getCssRules();
        if (rules.getLength() == 0) {
            return false;
        }
        for (int i = 0; i < rules.getLength(); ++i) {
            CSSRule rule = rules.item(i);
            String selectorText_ = ((CSSStyleRule)rule).getSelectorText();
            if (!selectorStr.equals(selectorText_)) continue;
            CSSStyleDeclaration ss = ((CSSStyleRule)rule).getStyle();
            String propertyValue = ss.getPropertyValue(property);
            return !"".equals(propertyValue) && propertyValue != null;
        }
        return false;
    }

    public static boolean checkCssPropertyAndValue(String cssStr, String selectorStr, String propertyName, String value) throws IOException {
        InputSource source = new InputSource((Reader)new StringReader(cssStr));
        source.setEncoding("UTF-8");
        CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
        CSSStyleSheet sheet = parser.parseStyleSheet(source, null, null);
        CSSRuleList rules = sheet.getCssRules();
        if (rules.getLength() == 0) {
            return false;
        }
        for (int i = 0; i < rules.getLength(); ++i) {
            CSSRule rule = rules.item(i);
            String selectorText_ = "";
            if (rule instanceof CSSPageRule && selectorStr.equals(selectorText_ = ((CSSPageRule)rule).getSelectorText())) {
                CSSStyleDeclaration ss = ((CSSPageRule)rule).getStyle();
                String propertyValue = ss.getPropertyValue(propertyName);
                return !"".equals(propertyValue) && propertyValue != null && propertyValue.equals(value);
            }
            if (!(rule instanceof CSSStyleRule) || !selectorStr.equals(selectorText_ = ((CSSStyleRule)rule).getSelectorText())) continue;
            CSSStyleDeclaration ss = ((CSSStyleRule)rule).getStyle();
            String propertyValue = ss.getPropertyValue(propertyName);
            return !"".equals(propertyValue) && propertyValue != null && propertyValue.equals(value);
        }
        return false;
    }

    public static boolean checkSingleStylePropertyAndValue(String cssStr, String propertyName, String value) throws IOException {
        InputSource source = new InputSource((Reader)new StringReader(cssStr));
        source.setEncoding("UTF-8");
        CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
        CSSStyleDeclaration decl = parser.parseStyleDeclaration(source);
        return !StringUtil.isBlank((CharSequence)decl.getPropertyValue(propertyName)) && decl.getPropertyValue(propertyName).equals(value);
    }

    public static boolean checkSingleStyleProperty(String cssStr, String propertyName) throws IOException {
        InputSource source = new InputSource((Reader)new StringReader(cssStr));
        source.setEncoding("UTF-8");
        CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
        CSSStyleDeclaration decl = parser.parseStyleDeclaration(source);
        return !StringUtil.isBlank((CharSequence)decl.getPropertyValue(propertyName));
    }

    public static String getSingleStylePropertyValue(String cssStr, String propertyName) throws IOException {
        InputSource source = new InputSource((Reader)new StringReader(cssStr));
        source.setEncoding("UTF-8");
        CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
        CSSStyleDeclaration decl = parser.parseStyleDeclaration(source);
        return decl.getPropertyValue(propertyName);
    }

    public static CSSStyleSheet addRuleProperty(String cssStr, String selectorText, String propertyName, String propertyValue, String priority) throws IOException {
        InputSource source = new InputSource((Reader)new StringReader(cssStr));
        source.setEncoding("UTF-8");
        CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
        CSSStyleSheet sheet = parser.parseStyleSheet(source, null, null);
        CSSRuleList rules = sheet.getCssRules();
        if (rules.getLength() == 0) {
            return null;
        }
        String selectorText_ = "";
        for (int i = 0; i < rules.getLength(); ++i) {
            CSSStyleDeclaration cd;
            CSSRule rule = rules.item(i);
            if (rule instanceof CSSPageRule && selectorText.equals(selectorText_ = ((CSSPageRule)rule).getSelectorText())) {
                cd = ((CSSPageRule)rule).getStyle();
                cd.setProperty(propertyName, propertyValue, priority);
            }
            if (!(rule instanceof CSSStyleRule) || !selectorText.equals(selectorText_ = ((CSSStyleRule)rule).getSelectorText())) continue;
            cd = ((CSSStyleRule)rule).getStyle();
            cd.setProperty(propertyName, propertyValue, priority);
        }
        return sheet;
    }

    public static CSSStyleSheet addRuleProperty(CSSStyleSheet sheet, String selectorText, String propertyName, String propertyValue, String priority) {
        CSSRuleList rules = sheet.getCssRules();
        if (rules.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < rules.getLength(); ++i) {
            CSSRule rule = rules.item(i);
            String selectorText_ = ((CSSStyleRule)rule).getSelectorText();
            if (!selectorText.equals(selectorText_)) continue;
            CSSStyleDeclaration cd = ((CSSStyleRule)rule).getStyle();
            cd.setProperty(propertyName, propertyValue, priority);
        }
        return sheet;
    }

    public static CSSStyleDeclaration addSingleStyleProperty(String cssStr, String propertyName, String value, String priority) throws IOException {
        InputSource source = new InputSource((Reader)new StringReader(cssStr));
        source.setEncoding("UTF-8");
        CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
        CSSStyleDeclaration decl = parser.parseStyleDeclaration(source);
        decl.setProperty(propertyName, value, priority);
        return decl;
    }

    public static CSSStyleDeclaration addSingleStyleProperty(CSSStyleDeclaration decl, String propertyName, String value, String priority) {
        decl.setProperty(propertyName, value, priority);
        return decl;
    }

    public static CSSStyleSheet deleteRule(String cssStr, String selectorText) throws IOException {
        InputSource source = new InputSource((Reader)new StringReader(cssStr));
        source.setEncoding("UTF-8");
        CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
        CSSStyleSheet sheet = parser.parseStyleSheet(source, null, null);
        CSSRuleList rules = sheet.getCssRules();
        if (rules.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < rules.getLength(); ++i) {
            CSSRule rule = rules.item(i);
            String selectorText_ = ((CSSStyleRule)rule).getSelectorText();
            if (!selectorText.equals(selectorText_)) continue;
            sheet.deleteRule(i);
        }
        return sheet;
    }

    public static CSSStyleSheet deleteRule(CSSStyleSheet sheet, String selectorText) {
        CSSRuleList rules = sheet.getCssRules();
        if (rules.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < rules.getLength(); ++i) {
            CSSRule rule = rules.item(i);
            String selectorText_ = ((CSSStyleRule)rule).getSelectorText();
            if (!selectorText.equals(selectorText_)) continue;
            sheet.deleteRule(i);
        }
        return sheet;
    }

    public static CSSStyleSheet deleteRuleProperty(String cssStr, String selectorText, String propertyName) throws IOException {
        InputSource source = new InputSource((Reader)new StringReader(cssStr));
        source.setEncoding("UTF-8");
        CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
        CSSStyleSheet sheet = parser.parseStyleSheet(source, null, null);
        CSSRuleList rules = sheet.getCssRules();
        if (rules.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < rules.getLength(); ++i) {
            CSSRule rule = rules.item(i);
            String selectorText_ = ((CSSStyleRule)rule).getSelectorText();
            if (!selectorText.equals(selectorText_)) continue;
            CSSStyleDeclaration cd = ((CSSStyleRule)rule).getStyle();
            cd.removeProperty(propertyName);
        }
        return sheet;
    }

    public static CSSStyleDeclaration deleteSingleStyleProperty(String cssStr, String propertyName) throws IOException {
        InputSource source = new InputSource((Reader)new StringReader(cssStr));
        source.setEncoding("UTF-8");
        CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
        CSSStyleDeclaration decl = parser.parseStyleDeclaration(source);
        decl.removeProperty(propertyName);
        return decl;
    }

    public static CSSStyleDeclaration deleteSingleStyleProperty(CSSStyleDeclaration decl, String propertyName) {
        decl.removeProperty(propertyName);
        return decl;
    }

    public static CSSStyleSheet deleteRuleProperty(CSSStyleSheet sheet, String selectorText, String propertyName) {
        CSSRuleList rules = sheet.getCssRules();
        if (rules.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < rules.getLength(); ++i) {
            CSSRule rule = rules.item(i);
            String selectorText_ = ((CSSStyleRule)rule).getSelectorText();
            if (!selectorText.equals(selectorText_)) continue;
            CSSStyleDeclaration cd = ((CSSStyleRule)rule).getStyle();
            cd.removeProperty(propertyName);
        }
        return sheet;
    }

    public static void main(String[] args) throws IOException {
        String q = "body {\n            font-family: AlibabaPuHuiTi-Light,HanaMinB;\n            line-height: 1.2;\n            font-size:12px;\n            font-weight:normal\n            /*\u8bbe\u7f6e\u80cc\u666f\u8272*/\n            /*background: #00FF00 ;*/\n            /*\u8bbe\u7f6e\u80cc\u666f\u56fe\u7247*/\n            background-image:url(data:image/gif;base64,AAAA) no-repeat fixed top;\n        }";
        String a = "background: #ffcc44";
        String b = "body {/*background: #00FF00 ;*/font-family: AlibabaPuHuiTi-Light,HanaMinB;background-image:url(data:image/gif;base64,AAAA) no-repeat fixed top;background: #00FF00 ;-fs-print-hidden:true}";
        log.debug(CSSParser.checkCssProperty(b, "body", "background") + "");
        log.debug(CSSParser.deleteRuleProperty(b, "body", "background-image").toString());
        log.debug(CSSParser.checkCssPropertyAndValue(b, "body", "-fs-print-hidden", "true") + "");
        log.debug(CSSParser.checkCssProperty(a, "", "background") + "");
    }
}

