/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.htmladapter.base.thymeleaf;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import ink.rayin.htmladapter.base.utils.CodeMessage;
import ink.rayin.htmladapter.base.utils.RayinException;
import ink.rayin.tools.utils.Charsets;
import ink.rayin.tools.utils.ResourceUtil;
import java.nio.charset.Charset;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

public class ThymeleafHandler {
    private static TemplateEngine templateEngine = new TemplateEngine();
    private static Logger logger = LoggerFactory.getLogger(ThymeleafHandler.class);
    private static ThymeleafHandler thymeleafHandler = new ThymeleafHandler();

    private ThymeleafHandler() {
    }

    public static ThymeleafHandler getInstance() {
        return thymeleafHandler;
    }

    public String templateEngineProcessByString(String htmlStr, JSONObject jsonData) {
        Context context = new Context();
        if (jsonData != null) {
            context.setVariables((Map)JSON.parseObject((String)jsonData.toJSONString(new JSONWriter.Feature[0]), Map.class));
        }
        String r = null;
        try {
            r = templateEngine.process(htmlStr, (IContext)context);
        }
        catch (Exception e) {
            r = e.getCause().toString().replace("org.attoparser.ParseException: Exception evaluating OGNL expression:", "The Data paraeter error:");
            logger.debug(r, (Throwable)e);
            throw new RayinException(CodeMessage.DATA_RESOLVE_FAIL, r, e);
        }
        return r;
    }

    public String templateEngineProcessByPath(String filePath, JSONObject jsonData) {
        Context context = new Context();
        if (jsonData != null) {
            context.setVariables((Map)JSON.parseObject((String)jsonData.toJSONString(new JSONWriter.Feature[0]), Map.class));
        }
        String r = null;
        try {
            r = templateEngine.process(ResourceUtil.getResourceAsString((String)filePath, (Charset)Charsets.UTF_8), (IContext)context);
        }
        catch (Exception e) {
            r = e.getCause().toString().replace("org.attoparser.ParseException: Exception evaluating OGNL expression:", "The Data paraeter error:");
            logger.debug(r);
        }
        return r;
    }

    static {
        templateEngine.getConfiguration();
    }
}

