/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.springboot;

import icu.easyj.maven.plugin.mojo.AbstractEasyjMojo;
import java.io.IOException;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public abstract class AbstractSpringBootMojo
extends AbstractEasyjMojo {
    protected String springBootMavenPluginVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isSpringBootApplication()) {
            this.info("Skip this goal, because this project is not a spring-boot application.");
            return;
        }
        try {
            this.doExecute();
        }
        catch (IOException e) {
            throw new MojoExecutionException("IO exception", (Exception)e);
        }
    }

    abstract void doExecute() throws MojoExecutionException, MojoFailureException, IOException;

    private boolean isSpringBootApplication() {
        if ("jar".equalsIgnoreCase(this.project.getPackaging())) {
            List plugins = this.project.getBuildPlugins();
            for (Plugin plugin : plugins) {
                if (!"org.springframework.boot".equals(plugin.getGroupId()) || !"spring-boot-maven-plugin".equals(plugin.getArtifactId())) continue;
                this.springBootMavenPluginVersion = plugin.getVersion();
                return true;
            }
        }
        return false;
    }
}

