/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.replace;

import icu.easyj.maven.plugin.mojo.AbstractEasyjMojo;
import icu.easyj.maven.plugin.mojo.utils.IOUtils;
import icu.easyj.maven.plugin.mojo.utils.ObjectUtils;
import icu.easyj.maven.plugin.mojo.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="replace-java", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class ReplaceJavaMojo
extends AbstractEasyjMojo {
    @Parameter
    private Set<String> mainPaths;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/easyj-maven-plugin_replace-java/java")
    private File generatedSourcesDirectory;
    @Parameter
    private Set<String> testPaths;
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/easyj-maven-plugin_replace-java/java")
    private File generatedTestSourcesDirectory;
    @Parameter
    private Map<String, String> placeholders;

    public void execute() throws MojoExecutionException {
        if (ObjectUtils.isEmpty(this.mainPaths) && ObjectUtils.isEmpty(this.testPaths)) {
            this.info("Skip, because 'mainPaths' and 'testPaths' is empty.");
            return;
        }
        if (this.placeholders == null) {
            this.placeholders = new HashMap<String, String>();
        }
        this.placeholders.put("project.groupId", this.project.getGroupId());
        this.placeholders.put("project.artifactId", this.project.getArtifactId());
        this.placeholders.put("project.version", this.project.getVersion());
        this.placeholders.put("revision", this.project.getVersion());
        try {
            if (this.replaceFiles(this.mainPaths, "src/main/java/", this.generatedSourcesDirectory)) {
                this.project.addCompileSourceRoot(this.generatedSourcesDirectory.getPath());
            }
            if (this.replaceFiles(this.testPaths, "src/test/java/", this.generatedTestSourcesDirectory)) {
                this.project.addTestCompileSourceRoot(this.generatedTestSourcesDirectory.getPath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Replace placeholder failed", e);
        }
    }

    private boolean replaceFiles(Set<String> paths, String basePath, File generatedSourcesDirectory) throws IOException {
        if (ObjectUtils.isEmpty(paths)) {
            return false;
        }
        boolean hasGeneratedFile = false;
        for (String relativePath : paths) {
            File file = new File(this.outputDirectory, basePath + relativePath);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                this.warn("Directory is not supported: " + file.getPath());
                continue;
            }
            if (!this.replaceFile(file, relativePath)) continue;
            hasGeneratedFile = true;
        }
        return hasGeneratedFile;
    }

    private boolean replaceFile(File file, String relativePath) throws IOException {
        String text = this.readAndReplacePlaceholder(file);
        if (StringUtils.isEmpty(text)) {
            return false;
        }
        String generatedFilePath = this.generatedSourcesDirectory.getPath() + "/" + relativePath.substring(0, relativePath.indexOf(".java") + ".java".length());
        File generatedFile = new File(generatedFilePath);
        generatedFile.getParentFile().mkdirs();
        IOUtils.createFile(generatedFile, text);
        this.info("Generate java file: %s -> %s", file.getName(), generatedFile.getPath());
        return true;
    }

    private String readAndReplacePlaceholder(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (Scanner sc = new Scanner(file);){
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                for (Map.Entry<String, String> entry : this.placeholders.entrySet()) {
                    String placeholder = "${" + entry.getKey() + "}";
                    if (!line.contains(placeholder)) continue;
                    line = line.replace(placeholder, entry.getValue());
                }
                sb.append(line).append("\n");
            }
        }
        return sb.toString().trim();
    }
}

