/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.metadata;

import java.util.HashMap;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.EmptyRateLimit;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.RateLimit;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.openai.metadata.OpenAiRateLimit;
import org.springframework.ai.openai.metadata.OpenAiUsage;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class OpenAiChatResponseMetadata
extends HashMap<String, Object>
implements ChatResponseMetadata {
    protected static final String AI_METADATA_STRING = "{ @type: %1$s, id: %2$s, usage: %3$s, rateLimit: %4$s }";
    private final String id;
    @Nullable
    private RateLimit rateLimit;
    private final Usage usage;

    public static OpenAiChatResponseMetadata from(OpenAiApi.ChatCompletion result) {
        Assert.notNull((Object)result, (String)"OpenAI ChatCompletionResult must not be null");
        OpenAiUsage usage = OpenAiUsage.from(result.usage());
        OpenAiChatResponseMetadata chatResponseMetadata = new OpenAiChatResponseMetadata(result.id(), usage);
        return chatResponseMetadata;
    }

    protected OpenAiChatResponseMetadata(String id, OpenAiUsage usage) {
        this(id, usage, null);
    }

    protected OpenAiChatResponseMetadata(String id, OpenAiUsage usage, @Nullable OpenAiRateLimit rateLimit) {
        this.id = id;
        this.usage = usage;
        this.rateLimit = rateLimit;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public RateLimit getRateLimit() {
        RateLimit rateLimit = this.rateLimit;
        return rateLimit != null ? rateLimit : new EmptyRateLimit();
    }

    public Usage getUsage() {
        Usage usage = this.usage;
        return usage != null ? usage : new EmptyUsage();
    }

    public OpenAiChatResponseMetadata withRateLimit(RateLimit rateLimit) {
        this.rateLimit = rateLimit;
        return this;
    }

    @Override
    public String toString() {
        return AI_METADATA_STRING.formatted(this.getClass().getName(), this.getId(), this.getUsage(), this.getRateLimit());
    }
}

