/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.naming.context;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import javax.naming.Binding;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.naming.context.ContextTreeModel;

public class ContextNode
extends DefaultMutableTreeNode
implements NamespaceChangeListener {
    public static final EventType NODE_CHANGED_EVENT = new EventType("NODE_CHANGED_EVENT");
    private EventContext context = null;
    private Class[] displayClasses = null;
    private boolean displayFields = false;
    private ContextTreeModel treeModel = null;

    public ContextNode(ContextTreeModel treeModel, String name, EventContext context, Class[] displayClasses, boolean displayFields) throws NamingException {
        super(name);
        this.treeModel = treeModel;
        this.context = context;
        this.displayClasses = displayClasses;
        this.displayFields = displayFields;
        NamingEnumeration<Binding> bindings = this.context.listBindings("");
        while (bindings.hasMore()) {
            Binding binding = bindings.next();
            this.objectAdded(new NamingEvent(this.context, 0, binding, null, null));
        }
        this.context.addNamingListener("", 0, (NamingListener)this);
        this.context.addNamingListener("", 2, (NamingListener)this);
    }

    public ContextNode(Object userObject) {
        super(userObject, true);
    }

    public void objectAdded(NamingEvent event) {
        Binding item = event.getNewBinding();
        if (item.getObject() instanceof EventContext) {
            EventContext context = (EventContext)item.getObject();
            try {
                Name name = context.getNameParser("").parse(context.getNameInNamespace());
                this.add(new ContextNode(this.treeModel, name.get(name.size() - 1).toString(), context, this.displayClasses, this.displayFields));
            }
            catch (NamingException exception) {
                Logger.warning((Object)this, (String)"objectAdded", (Throwable)exception);
            }
        } else if (this.display(item.getObject())) {
            this.contructObject(this, item.getObject());
        }
        this.treeModel.fireTreeStructureChanged(this, this.getPath(), null, null);
    }

    public void objectRemoved(NamingEvent event) {
        Binding item = event.getOldBinding();
        if (!(item.getObject() instanceof EventContext)) {
            this.remove(item.getObject());
        }
        this.treeModel.fireTreeStructureChanged(this, this.getPath(), null, null);
    }

    private void remove(Object object) {
        if (!this.display(object)) {
            return;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getChildAt(i);
            if (!node.getUserObject().equals(object)) continue;
            this.remove(i);
            return;
        }
        throw new NullPointerException("Could not find " + object);
    }

    public void objectRenamed(NamingEvent event) {
        throw new RuntimeException("objectRenamed(" + event.toString() + ") not implemented yet");
    }

    public void namingExceptionThrown(NamingExceptionEvent event) {
        Logger.warning((Object)this, (String)"namingExceptionThrown", (Throwable)event.getException());
    }

    private boolean display(Object object) {
        return this.display(object.getClass());
    }

    private boolean display(Class myClass) {
        if (this.displayClasses == null) {
            return true;
        }
        if (myClass == null) {
            return false;
        }
        for (int i = 0; i < this.displayClasses.length; ++i) {
            if (!this.displayClasses[i].equals(myClass)) continue;
            return true;
        }
        Class<?>[] interfaces = myClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            for (int j = 0; j < this.displayClasses.length; ++j) {
                if (!interfaces[i].equals(this.displayClasses[j])) continue;
                return true;
            }
        }
        return this.display(myClass.getSuperclass());
    }

    private DefaultMutableTreeNode contructObject(DefaultMutableTreeNode root, Object object) {
        if (!this.displayFields) {
            root.add(new DefaultMutableTreeNode(object));
        } else {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(object);
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
                PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
                for (int i = 0; i < descriptors.length; ++i) {
                    String name = "attr:" + descriptors[i].getName();
                    String value = " value:" + descriptors[i].getReadMethod().invoke(object, null).toString();
                    child.add(new DefaultMutableTreeNode(name + "  " + value));
                }
                root.add(child);
            }
            catch (Exception exception2) {
                Object exception2 = null;
            }
        }
        return root;
    }
}

