/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.naming;

import java.net.InetAddress;
import java.net.URL;
import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.spi.InitialContextFactory;
import nl.tudelft.simulation.logger.Logger;
import nl.tudelft.simulation.naming.InitialEventContext;
import nl.tudelft.simulation.naming.RemoteContext;
import nl.tudelft.simulation.naming.RemoteContextClient;
import nl.tudelft.simulation.naming.RemoteContextInterface;

public class RemoteContextFactory
implements InitialContextFactory {
    private static RemoteContextClient context = null;

    public synchronized Context getInitialContext(Hashtable environment) {
        if (context != null) {
            return context;
        }
        try {
            URL url = new URL(environment.get("java.naming.provider.url").toString());
            Registry registry = LocateRegistry.getRegistry(url.getHost(), url.getPort());
            try {
                registry.list();
            }
            catch (ConnectException connectException) {
                if (!(url.getHost().equals("localhost") || url.getHost().equals("127.0.0.1") || url.getHost().equals(InetAddress.getLocalHost().getHostName()) || url.getHost().equals(InetAddress.getLocalHost().getHostAddress()))) {
                    throw new IllegalArgumentException("cannot create registry on remote host");
                }
                registry = LocateRegistry.createRegistry(url.getPort());
            }
            RemoteContextInterface remoteContext = null;
            try {
                remoteContext = (RemoteContextInterface)registry.lookup(url.getFile());
            }
            catch (NotBoundException notBoundException) {
                Hashtable wrappedEnvironment = new Hashtable();
                Iterator iterator = environment.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = iterator.next().toString();
                    if (!key.startsWith("wrapped.naming")) continue;
                    wrappedEnvironment.put(key.replaceFirst("wrapped.naming", "java.naming"), environment.get(key));
                }
                if (wrappedEnvironment.isEmpty()) {
                    throw new IllegalArgumentException("no wrapped initial context defined");
                }
                InitialEventContext wrappedContext = new InitialEventContext(wrappedEnvironment);
                remoteContext = new RemoteContext(wrappedContext);
                registry.bind(url.getFile(), remoteContext);
            }
            context = new RemoteContextClient(remoteContext);
            return context;
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"getInitialContext", (Throwable)exception);
            return null;
        }
    }
}

