/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.language.concurrent;

import java.util.HashMap;
import java.util.Map;

public final class Monitor {
    private static Map locks = new HashMap();

    private Monitor() {
    }

    public static void lock(Object object) {
        Monitor.lock(object, Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lock(Object object, Thread requestor) {
        Map map = locks;
        synchronized (map) {
            if (!locks.containsKey(object)) {
                locks.put(object, new MonitorThread(requestor, object));
            } else {
                MonitorThread thread = (MonitorThread)locks.get(object);
                if (thread.getOwner().equals(requestor)) {
                    thread.increaseCounter();
                } else {
                    Object object2 = object;
                    synchronized (object2) {
                        locks.put(object, new MonitorThread(requestor, object));
                    }
                }
            }
        }
    }

    public static void unlock(Object object) {
        Monitor.unlock(object, Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlock(Object object, Thread owner) {
        Map map = locks;
        synchronized (map) {
            MonitorThread thread = (MonitorThread)locks.get(object);
            if (thread == null) {
                throw new IllegalMonitorStateException("object(" + object + ") is not locked");
            }
            if (!thread.getOwner().equals(owner)) {
                throw new IllegalMonitorStateException(owner + " cannot" + " unlock object owned by " + thread.getOwner());
            }
            thread.decreaseCounter();
            if (thread.getCounter() == 0) {
                thread.interrupt();
                locks.remove(object);
            }
        }
    }

    private static class MonitorThread
    extends Thread {
        private Object object = null;
        private Thread owner = null;
        private int counter = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MonitorThread(Thread owner, Object object) {
            super("MonitorThread on " + object.getClass());
            this.setDaemon(true);
            this.owner = owner;
            Object object2 = object;
            synchronized (object2) {
                this.object = object;
                ++this.counter;
                this.start();
            }
            object2 = owner;
            synchronized (object2) {
                try {
                    this.owner.wait();
                }
                catch (InterruptedException exception2) {
                    Object exception2 = null;
                }
            }
        }

        public synchronized int getCounter() {
            return this.counter;
        }

        public synchronized void decreaseCounter() {
            this.counter = Math.max(0, this.counter - 1);
        }

        public synchronized void increaseCounter() {
            ++this.counter;
        }

        public Thread getOwner() {
            return this.owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object = this.object;
                synchronized (object) {
                    this.owner.interrupt();
                    this.join();
                }
            }
            catch (Exception exception) {
                Object var1_3 = null;
            }
        }
    }
}

