/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.ode.integrators;

import nl.tudelft.simulation.jstats.ode.DifferentialEquationInterface;
import nl.tudelft.simulation.jstats.ode.integrators.CachingNumericalIntegrator;

public class Adams
extends CachingNumericalIntegrator {
    public Adams(double timeStep, DifferentialEquationInterface equation) {
        super(timeStep, equation, 4, (short)3, 10);
    }

    public Adams(double timeStep, DifferentialEquationInterface equation, short integrationMethod, int startingSubSteps) {
        super(timeStep, equation, 4, integrationMethod, startingSubSteps);
    }

    public double[] next(double x) {
        double[] y0 = super.getY(0);
        double[] dy0 = super.getDY(0);
        double[] dy1 = super.getDY(1);
        double[] dy2 = super.getDY(2);
        double[] dy3 = super.getDY(3);
        double[] sum = super.add(super.multiply(-9.0, dy3), super.multiply(37.0, dy2), super.multiply(-59.0, dy1), super.multiply(55.0, dy0));
        sum = super.multiply(this.timeStep / 24.0, sum);
        double[] p = super.add(y0, sum);
        sum = super.add(dy2, super.multiply(-5.0, dy1), super.multiply(19.0, dy0), super.multiply(9.0, this.equation.dy(x + this.timeStep, p)));
        return super.add(y0, super.multiply(this.timeStep / 24.0, sum));
    }
}

