/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.math;

public final class ProbMath {
    private ProbMath() {
    }

    public static double faculty(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n! with n<0 is invalid");
        }
        if (n > 170) {
            throw new IllegalArgumentException("n! with n>170 is infinitely");
        }
        double result = 1.0;
        for (int i = 1; i <= n; ++i) {
            result *= (double)i;
        }
        return result;
    }

    public static double permutations(int n, int m) {
        if (m > n) {
            throw new IllegalArgumentException("permutations of (n,m) with m>n ?...");
        }
        return ProbMath.faculty(n) / (ProbMath.faculty(m) * ProbMath.faculty(n - m));
    }
}

