/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions;

import nl.tudelft.simulation.jstats.distributions.DistContinuous;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

public class DistWeibull
extends DistContinuous {
    private double alpha;
    private double beta;

    public DistWeibull(StreamInterface stream, double alpha, double beta) {
        super(stream);
        if (!(alpha > 0.0) || !(beta > 0.0)) {
            throw new IllegalArgumentException("Error Weibull - alpha <= 0.0 or beta <= 0.0");
        }
        this.alpha = alpha;
        this.beta = beta;
    }

    public double draw() {
        return this.beta * Math.pow(-Math.log(this.stream.nextDouble()), 1.0 / this.alpha);
    }

    public double probDensity(double observation) {
        if (observation > 0.0) {
            return this.alpha * Math.pow(this.beta, -this.alpha) * Math.pow(observation, this.alpha - 1.0) * Math.exp(Math.pow(-1.0 * (observation / this.beta), this.alpha));
        }
        return 0.0;
    }

    public String toString() {
        return "Weibull(" + this.alpha + "," + this.beta + ")";
    }
}

