/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions;

import nl.tudelft.simulation.jstats.distributions.DistDiscrete;
import nl.tudelft.simulation.jstats.math.ProbMath;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

public class DistPoisson
extends DistDiscrete {
    private double lambda;
    private double expl;

    public DistPoisson(StreamInterface stream, double lambda) {
        super(stream);
        if (!(lambda > 0.0)) {
            throw new IllegalArgumentException("Error Poisson - lambda<=0");
        }
        this.lambda = lambda;
        this.expl = Math.exp(-this.lambda);
    }

    public long draw() {
        double s = 1.0;
        long x = -1L;
        do {
            ++x;
        } while ((s *= this.stream.nextDouble()) > this.expl);
        return x;
    }

    public double probability(int observation) {
        if (observation >= 0) {
            return Math.exp(-this.lambda) * Math.pow(this.lambda, observation) / ProbMath.faculty(observation);
        }
        return 0.0;
    }

    public String toString() {
        return "Poisson(" + this.lambda + ")";
    }
}

