/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions;

import nl.tudelft.simulation.jstats.distributions.DistDiscrete;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

public class DistGeometric
extends DistDiscrete {
    private double p;
    private double lnp;

    public DistGeometric(StreamInterface stream, double p) {
        super(stream);
        if (!(p > 0.0) || !(p < 1.0)) {
            throw new IllegalArgumentException("Error Geometric - p<=0 or p>=1");
        }
        this.p = p;
        this.lnp = Math.log(1.0 - this.p);
    }

    public long draw() {
        double u = this.stream.nextDouble();
        return (long)Math.floor(Math.log(u) / this.lnp);
    }

    public double probability(int observation) {
        if (observation >= 0) {
            return this.p * Math.pow(1.0 - this.p, observation);
        }
        return 0.0;
    }

    public String toString() {
        return "Geometric(" + this.p + ")";
    }
}

