/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions;

import nl.tudelft.simulation.jstats.distributions.DistDiscrete;
import nl.tudelft.simulation.jstats.math.ProbMath;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

public class DistBinomial
extends DistDiscrete {
    private long n;
    private double p;

    public DistBinomial(StreamInterface stream, long n, double p) {
        super(stream);
        if (n <= 0L || !(p > 0.0) || !(p < 1.0)) {
            throw new IllegalArgumentException("Error Binomial - n<=0 or p<=0.0 or p>=1.0");
        }
        this.n = n;
        this.p = p;
    }

    public long draw() {
        long x = 0L;
        for (long i = 0L; i < this.n; ++i) {
            if (!(this.stream.nextDouble() <= this.p)) continue;
            ++x;
        }
        return x;
    }

    public double probability(int observation) {
        if ((long)observation <= this.n && observation >= 0) {
            return ProbMath.permutations((int)this.n, observation) * Math.pow(this.p, observation) * Math.pow(1.0 - this.p, this.n - (long)observation);
        }
        return 0.0;
    }

    public String toString() {
        return "Binomial(" + this.n + "," + this.p + ")";
    }
}

