/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions;

import nl.tudelft.simulation.jstats.distributions.DistDiscrete;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

public class DistBernoulli
extends DistDiscrete {
    private double p;

    public DistBernoulli(StreamInterface stream, double p) {
        super(stream);
        if (!(p >= 0.0) || !(p <= 1.0)) {
            throw new IllegalArgumentException("Error Exponential - p<0 or p>1 (p=" + p + ")");
        }
        this.p = p;
    }

    public long draw() {
        if (this.stream.nextDouble() <= this.p) {
            return 1L;
        }
        return 0L;
    }

    public double probability(int observation) {
        if (observation == 0) {
            return 1.0 - this.p;
        }
        if (observation == 1) {
            return this.p;
        }
        return 0.0;
    }

    public String toString() {
        return "Bernoulli(" + this.p + ")";
    }
}

