/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.charts.histogram;

import nl.tudelft.simulation.event.EventInterface;
import nl.tudelft.simulation.event.EventListenerInterface;
import org.jfree.data.AbstractDataset;

public class HistogramSeries
extends AbstractDataset
implements EventListenerInterface {
    private String name;
    private Bin[] bins = null;

    public HistogramSeries(String name, double[] domain, double[] range, int numberOfBins) {
        this.name = name;
        this.bins = new Bin[numberOfBins + 2];
        double binWidth = (domain[1] - domain[0]) / (double)numberOfBins * 1.0;
        double min = domain[0] - binWidth;
        for (int i = 0; i < numberOfBins + 2; ++i) {
            this.bins[i] = new Bin(new double[]{min, min + binWidth}, range);
            if (range != null) {
                this.bins[i].setFixed(true);
            }
            min += binWidth;
        }
        this.fireDatasetChanged();
    }

    public String getName() {
        return this.name;
    }

    public Number getEndXValue(int bin) {
        return this.bins[bin].getEndXValue();
    }

    public Number getEndYValue(int bin) {
        return this.bins[bin].getEndYValue();
    }

    public Number getStartXValue(int bin) {
        return this.bins[bin].getStartXValue();
    }

    public Number getStartYValue(int bin) {
        return this.bins[bin].getStartYValue();
    }

    public int getBinCount() {
        return this.bins.length;
    }

    public Number getXValue(int bin) {
        return this.bins[bin].getXValue();
    }

    public Number getYValue(int bin) {
        return this.bins[bin].getYValue();
    }

    public synchronized void notify(EventInterface event) {
        double value = ((Number)event.getContent()).doubleValue();
        this.bins[this.resolveBin(value)].increase();
        this.fireDatasetChanged();
    }

    private int resolveBin(double value) {
        if (value <= this.bins[1].getStartXValue().doubleValue()) {
            return 0;
        }
        for (int i = 1; i < this.bins.length - 1; ++i) {
            if (!(value > this.bins[i].getStartXValue().doubleValue()) || !(value <= this.bins[i].getEndXValue().doubleValue())) continue;
            return i;
        }
        return this.bins.length - 1;
    }

    private class Bin {
        private double[] domain;
        private double[] range = null;
        private int observations = 0;
        private boolean fixed = false;

        public Bin(double[] domain, double[] range) {
            this.domain = domain;
            if (range == null) {
                this.range = new double[]{0.0, 1.0};
            } else {
                this.range = range;
                this.fixed = true;
            }
        }

        public void increase() {
            ++this.observations;
            if (!this.fixed && (double)this.observations >= this.range[1]) {
                this.range[1] = this.observations;
            }
        }

        public Number getStartXValue() {
            return new Double(this.domain[0]);
        }

        public Number getStartYValue() {
            return new Double(this.range[0]);
        }

        public Number getEndXValue() {
            return new Double(this.domain[1]);
        }

        public Number getEndYValue() {
            return new Double(this.range[1]);
        }

        public synchronized Number getXValue() {
            return new Double(0.5 * (this.domain[1] - this.domain[0]));
        }

        public Number getYValue() {
            return new Integer(this.observations);
        }

        public void setFixed(boolean fixed) {
            this.fixed = fixed;
        }
    }
}

