/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.charts.histogram;

import java.util.ArrayList;
import java.util.Arrays;
import nl.tudelft.simulation.jstats.charts.histogram.HistogramSeries;
import org.jfree.data.AbstractDataset;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.DatasetChangeListener;
import org.jfree.data.IntervalXYDataset;

public class HistogramDataset
extends AbstractDataset
implements IntervalXYDataset,
DatasetChangeListener {
    protected double[] domain = null;
    protected double[] range = null;
    protected int numberOfBins = 0;
    protected HistogramSeries[] series = new HistogramSeries[0];

    public HistogramDataset(double[] domain, double[] range, int numberOfBins) {
        this.domain = domain;
        this.range = range;
        this.numberOfBins = numberOfBins;
    }

    public synchronized HistogramSeries addSeries(String name) {
        HistogramSeries series = new HistogramSeries(name, this.domain, this.range, this.numberOfBins);
        this.addSeries(series);
        return series;
    }

    public synchronized void addSeries(HistogramSeries newSeries) {
        newSeries.addChangeListener(this);
        ArrayList<HistogramSeries> list = new ArrayList<HistogramSeries>(Arrays.asList(this.series));
        list.add(newSeries);
        this.series = list.toArray(new HistogramSeries[list.size()]);
        this.fireDatasetChanged();
    }

    public void datasetChanged(DatasetChangeEvent arg0) {
        if (arg0 != null) {
            this.fireDatasetChanged();
        }
    }

    public Number getEndXValue(int series, int bin) {
        return this.series[series].getEndXValue(bin);
    }

    public Number getEndYValue(int series, int bin) {
        return this.series[series].getEndYValue(bin);
    }

    public Number getStartXValue(int series, int bin) {
        return this.series[series].getStartXValue(bin);
    }

    public Number getStartYValue(int series, int bin) {
        return this.series[series].getStartYValue(bin);
    }

    public int getItemCount(int series) {
        return this.series[series].getBinCount();
    }

    public Number getXValue(int series, int bin) {
        return this.series[series].getXValue(bin);
    }

    public Number getYValue(int series, int bin) {
        return this.series[series].getYValue(bin);
    }

    public int getSeriesCount() {
        return this.series.length;
    }

    public String getSeriesName(int series) {
        return this.series[series].getName();
    }

    public double getEndX(int series, int bin) {
        return this.series[series].getEndXValue(bin).doubleValue();
    }

    public double getEndY(int series, int bin) {
        return this.series[series].getEndYValue(bin).doubleValue();
    }

    public double getStartX(int series, int bin) {
        return this.series[series].getStartXValue(bin).doubleValue();
    }

    public double getStartY(int series, int bin) {
        return this.series[series].getStartYValue(bin).doubleValue();
    }

    public double getX(int series, int bin) {
        return this.series[series].getXValue(bin).doubleValue();
    }

    public double getY(int series, int bin) {
        return this.series[series].getYValue(bin).doubleValue();
    }
}

