/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.operations.reflection;

import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import nl.tudelft.simulation.dsol.interpreter.Frame;
import nl.tudelft.simulation.dsol.interpreter.InterpreterException;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantMethodref;
import nl.tudelft.simulation.dsol.interpreter.operations.InvokeOperation;
import nl.tudelft.simulation.language.primitives.Primitive;
import nl.tudelft.simulation.language.reflection.ClassUtil;
import nl.tudelft.simulation.language.reflection.MethodSignature;

public class INVOKESTATIC
extends InvokeOperation {
    public static final int OP = 184;
    protected int index = -1;

    public INVOKESTATIC(DataInput dataInput) throws IOException {
        this.index = dataInput.readUnsignedShort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame execute(Frame frame) {
        try {
            Method method = null;
            ConstantMethodref constantMethodref = (ConstantMethodref)frame.getConstantPool()[this.index];
            Class referenceClass = constantMethodref.getConstantClass().getValue().getClassValue();
            Class[] parameterTypes = new MethodSignature(constantMethodref.getConstantNameAndType().getDescriptor()).getParameterTypes();
            String methodName = constantMethodref.getConstantNameAndType().getName();
            method = ClassUtil.resolveMethod((Class)referenceClass, (String)methodName, (Class[])parameterTypes);
            OperandStack operandStack = frame.getOperandStack();
            synchronized (operandStack) {
                Object[] args = new Object[parameterTypes.length];
                for (int i = args.length - 1; i > -1; --i) {
                    args[i] = Primitive.cast((Class)parameterTypes[i], (Object)frame.getOperandStack().pop());
                }
                return this.execute(frame, method.getDeclaringClass(), method, args);
            }
        }
        catch (Exception exception) {
            throw new InterpreterException(exception);
        }
    }

    public Frame execute(Frame frame, Object objectRef, Method method, Object[] arguments) throws Exception {
        ((AccessibleObject)method).setAccessible(true);
        Object result = null;
        try {
            result = method.invoke(objectRef, arguments);
        }
        catch (Exception exception) {
            frame.getOperandStack().push(exception.getCause());
            throw new InterpreterException("ATHROW created");
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            frame.getOperandStack().push(result);
        }
        return null;
    }

    public int getByteLength() {
        return 3;
    }

    public int getOpcode() {
        return 184;
    }
}

