/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.classfile;

import java.io.DataInput;
import java.io.IOException;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantUTF8;

public class ConstantString
extends Constant {
    private int stringIndex;

    public ConstantString(Constant[] constantPool, DataInput inputStream) throws IOException {
        this(constantPool, inputStream.readUnsignedShort());
    }

    public ConstantString(Constant[] constantPool, int stringIndex) {
        super(constantPool);
        this.stringIndex = stringIndex;
    }

    public int getTag() {
        return 8;
    }

    public int getStringIndex() {
        return this.stringIndex;
    }

    public String getValue() {
        return ((ConstantUTF8)this.constantPool[this.stringIndex]).getValue();
    }

    public String toString() {
        return "ConstantString[index=" + this.stringIndex + "]";
    }
}

