/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.classfile;

import java.io.DataInput;
import java.io.IOException;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantUTF8;

public class ConstantNameAndType
extends Constant {
    private int nameIndex;
    private int descriptorIndex;

    public ConstantNameAndType(Constant[] constantPool, DataInput inputStream) throws IOException {
        this(constantPool, inputStream.readUnsignedShort(), inputStream.readUnsignedShort());
    }

    public ConstantNameAndType(Constant[] constantPool, int nameIndex, int descriptorIndex) {
        super(constantPool);
        this.nameIndex = nameIndex;
        this.descriptorIndex = descriptorIndex;
    }

    public int getTag() {
        return 12;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public String getName() {
        return ((ConstantUTF8)this.constantPool[this.nameIndex]).getValue();
    }

    public String getDescriptor() {
        return ((ConstantUTF8)this.constantPool[this.descriptorIndex]).getValue();
    }

    public String toString() {
        return "ConstantNameAndType[name_index=" + this.nameIndex + " descriptor_index=" + this.descriptorIndex + "]";
    }
}

