/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.tudelft.simulation.dsol.interpreter.Frame;
import nl.tudelft.simulation.dsol.interpreter.InterpreterException;
import nl.tudelft.simulation.dsol.interpreter.LocalVariable;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.Operation;
import nl.tudelft.simulation.dsol.interpreter.classfile.ClassDescriptor;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.classfile.ExceptionEntry;
import nl.tudelft.simulation.dsol.interpreter.classfile.MethodDescriptor;
import nl.tudelft.simulation.dsol.interpreter.operations.ATHROW;
import nl.tudelft.simulation.dsol.interpreter.operations.FactoryInterface;
import nl.tudelft.simulation.dsol.interpreter.operations.InterpreterFactory;
import nl.tudelft.simulation.dsol.interpreter.operations.InvokeOperation;
import nl.tudelft.simulation.dsol.interpreter.operations.JumpOperation;
import nl.tudelft.simulation.dsol.interpreter.operations.RET;
import nl.tudelft.simulation.dsol.interpreter.operations.RETURN;
import nl.tudelft.simulation.dsol.interpreter.operations.ReturnOperation;
import nl.tudelft.simulation.dsol.interpreter.operations.VoidOperation;
import nl.tudelft.simulation.dsol.interpreter.operations.WIDE;
import nl.tudelft.simulation.dsol.interpreter.operations.custom.InterpreterOracleInterface;
import nl.tudelft.simulation.language.io.URLResource;
import nl.tudelft.simulation.language.reflection.ClassUtil;

public final class Interpreter {
    private static final Map CACHE = new HashMap();
    public static FactoryInterface INTERPRETER_FACTORY = null;
    static /* synthetic */ Class class$nl$tudelft$simulation$dsol$interpreter$operations$custom$InterpreterOracleInterface;
    static /* synthetic */ Class class$nl$tudelft$simulation$dsol$interpreter$Interpreter;

    public static void setFactory(FactoryInterface factory) {
        INTERPRETER_FACTORY = factory;
    }

    private Interpreter() {
    }

    public static Frame createFrame(Object object, AccessibleObject method, Object[] arguments) throws ClassNotFoundException, IOException {
        Frame frame = null;
        Object[] args = new Object[]{};
        if (arguments != null) {
            args = arguments;
        }
        if (CACHE.containsKey(method)) {
            frame = (Frame)((Frame)CACHE.get(method)).clone();
        } else {
            ClassDescriptor classDescriptor = null;
            classDescriptor = method instanceof Method ? ClassDescriptor.get(((Method)method).getDeclaringClass()) : ClassDescriptor.get(((Constructor)method).getDeclaringClass());
            MethodDescriptor methodDescriptor = classDescriptor.getMethod(method);
            OperandStack operandStack = new OperandStack(methodDescriptor.getMaxStack());
            LocalVariable[] localVariables = LocalVariable.newInstance(methodDescriptor.getLocalVariableTable());
            frame = new Frame(classDescriptor.getConstantPool(), localVariables, methodDescriptor.getOperations(), operandStack, methodDescriptor);
            CACHE.put(method, frame);
        }
        int modifiers = -1;
        int counter = 0;
        Class<?>[] parameterTypes = null;
        if (method instanceof Method) {
            parameterTypes = ((Method)method).getParameterTypes();
            modifiers = ((Method)method).getModifiers();
        } else {
            parameterTypes = ((Constructor)method).getParameterTypes();
            modifiers = ((Constructor)method).getModifiers();
        }
        if (!Modifier.isStatic(modifiers)) {
            frame.localVariables[counter++].setValue(object);
        }
        for (int i = 0; i < args.length; ++i) {
            frame.localVariables[counter++].setValue(arguments[i]);
            if (!parameterTypes[i].equals(Double.TYPE) && !parameterTypes[i].equals(Long.TYPE)) continue;
            ++counter;
        }
        if (nl.tudelft.simulation.logger.Logger.getLogLevel().intValue() <= Level.FINER.intValue()) {
            String logMessage = frame.getMethodDescriptor().getMethod().toString() + "\n" + Operation.toString(frame.getMethodDescriptor(), frame.getMethodDescriptor().getOperations());
            nl.tudelft.simulation.logger.Logger.finer((Object)(class$nl$tudelft$simulation$dsol$interpreter$Interpreter == null ? (class$nl$tudelft$simulation$dsol$interpreter$Interpreter = Interpreter.class$("nl.tudelft.simulation.dsol.interpreter.Interpreter")) : class$nl$tudelft$simulation$dsol$interpreter$Interpreter), (String)"createFrame", (String)logMessage);
        }
        return frame;
    }

    public static Frame aThrow(Operation operation, Frame frame, Stack frameStack) {
        ((ATHROW)operation).execute(frame);
        ExceptionEntry exceptionEntry = (ExceptionEntry)frame.getOperandStack().pop();
        if (exceptionEntry != null) {
            int operationIndex = frame.getMethodDescriptor().getOperationIndex(exceptionEntry.getHandler());
            frame.setReturnPosition(operationIndex);
            return frame;
        }
        Throwable throwable = (Throwable)frame.getOperandStack().pop();
        frameStack.pop();
        if (frameStack.isEmpty()) {
            throw new RuntimeException("\n----------------------\n" + throwable + ": " + frame.getLocalVariables()[0].getValue() + "." + frame.getMethodDescriptor().getName() + "\n----------------------");
        }
        Frame newFrame = (Frame)frameStack.peek();
        ((ATHROW)operation).setBytePosition(newFrame.getMethodDescriptor().getBytePosition(newFrame.getReturnPosition()));
        newFrame.getOperandStack().push(throwable);
        return Interpreter.aThrow(operation, newFrame, frameStack);
    }

    public static Object interpret(Stack frameStack) throws InterpreterException {
        Frame frame = (Frame)frameStack.peek();
        OperandStack operandStack = frame.getOperandStack();
        Constant[] constantPool = frame.getConstantPool();
        LocalVariable[] localVariables = frame.getLocalVariables();
        MethodDescriptor methodDescriptor = frame.getMethodDescriptor();
        int operationIndex = frame.getReturnPosition();
        boolean log = nl.tudelft.simulation.logger.Logger.getLogLevel().intValue() <= Level.FINEST.intValue();
        while (true) {
            Operation operation = frame.getOperations()[operationIndex];
            if (log) {
                nl.tudelft.simulation.logger.Logger.finest((Object)(class$nl$tudelft$simulation$dsol$interpreter$Interpreter == null ? Interpreter.class$("nl.tudelft.simulation.dsol.interpreter.Interpreter") : class$nl$tudelft$simulation$dsol$interpreter$Interpreter), (String)"interpret", (String)("" + operandStack));
                nl.tudelft.simulation.logger.Logger.finest((Object)(class$nl$tudelft$simulation$dsol$interpreter$Interpreter == null ? Interpreter.class$("nl.tudelft.simulation.dsol.interpreter.Interpreter") : class$nl$tudelft$simulation$dsol$interpreter$Interpreter), (String)"interpret", (String)("" + frameStack.size() + " " + operation));
            }
            if (operation instanceof WIDE) {
                operation = ((WIDE)operation).getTarget();
            }
            if (operation instanceof ATHROW) {
                frame = Interpreter.aThrow(operation, frame, frameStack);
                operandStack = frame.getOperandStack();
                constantPool = frame.getConstantPool();
                localVariables = frame.getLocalVariables();
                methodDescriptor = frame.getMethodDescriptor();
                operationIndex = frame.getReturnPosition();
                continue;
            }
            if (operation instanceof VoidOperation) {
                ((VoidOperation)operation).execute(operandStack, constantPool, localVariables);
                ++operationIndex;
                continue;
            }
            if (operation instanceof InvokeOperation) {
                Frame childFrame = null;
                try {
                    childFrame = ((InvokeOperation)operation).execute(frame);
                }
                catch (Exception exception) {
                    frame = Interpreter.aThrow(new ATHROW(methodDescriptor.getBytePosition(operationIndex)), frame, frameStack);
                    operandStack = frame.getOperandStack();
                    constantPool = frame.getConstantPool();
                    localVariables = frame.getLocalVariables();
                    methodDescriptor = frame.getMethodDescriptor();
                    operationIndex = frame.getReturnPosition();
                    continue;
                }
                ++operationIndex;
                if (childFrame == null) continue;
                frame.setReturnPosition(operationIndex);
                if (frame.isPaused()) {
                    return frame;
                }
                frame = childFrame;
                frameStack.push(frame);
                operandStack = frame.getOperandStack();
                constantPool = frame.getConstantPool();
                localVariables = frame.getLocalVariables();
                methodDescriptor = frame.getMethodDescriptor();
                operationIndex = 0;
                continue;
            }
            if (operation instanceof JumpOperation) {
                int offset;
                int bytePosition = offset = ((JumpOperation)operation).execute(operandStack, constantPool, localVariables);
                if (!(operation instanceof RET)) {
                    bytePosition += methodDescriptor.getBytePosition(operationIndex);
                }
                operationIndex = methodDescriptor.getOperationIndex(bytePosition);
                continue;
            }
            if (!(operation instanceof ReturnOperation)) continue;
            Object result = ((ReturnOperation)operation).execute(frame);
            frameStack.pop();
            if (frameStack.isEmpty()) {
                return result;
            }
            frame = (Frame)frameStack.peek();
            operandStack = frame.getOperandStack();
            constantPool = frame.getConstantPool();
            localVariables = frame.getLocalVariables();
            methodDescriptor = frame.getMethodDescriptor();
            operationIndex = frame.getReturnPosition();
            if (operation instanceof RETURN) continue;
            operandStack.push(result);
        }
    }

    public static Object invoke(Object object, String methodName, Object[] arguments, Class[] argumentTypes) {
        try {
            Executable method = null;
            method = !methodName.equals("<init>") ? (object instanceof Class ? ClassUtil.resolveMethod((Class)((Class)object), (String)methodName, (Class[])argumentTypes) : ClassUtil.resolveMethod(object.getClass(), (String)methodName, (Class[])argumentTypes)) : object.getClass().getDeclaredConstructor(argumentTypes);
            return Interpreter.invoke(object, method, arguments);
        }
        catch (Exception exception) {
            throw new InterpreterException(exception);
        }
    }

    public static Object invoke(Object object, AccessibleObject method, Object[] arguments) throws InterpreterException {
        if (nl.tudelft.simulation.logger.Logger.getLogLevel().intValue() <= Level.FINE.intValue()) {
            nl.tudelft.simulation.logger.Logger.fine((Object)(class$nl$tudelft$simulation$dsol$interpreter$Interpreter == null ? (class$nl$tudelft$simulation$dsol$interpreter$Interpreter = Interpreter.class$("nl.tudelft.simulation.dsol.interpreter.Interpreter")) : class$nl$tudelft$simulation$dsol$interpreter$Interpreter), (String)"invoke", (String)method.toString());
        }
        try {
            if (method instanceof Constructor && Modifier.isNative(((Constructor)method).getModifiers())) {
                return ((Constructor)method).newInstance(arguments);
            }
            if (method instanceof Method && Modifier.isNative(((Method)method).getModifiers())) {
                return ((Method)method).invoke(object, arguments);
            }
            Stack<Frame> frameStack = new Stack<Frame>();
            frameStack.push(Interpreter.createFrame(object, method, arguments));
            return Interpreter.interpret(frameStack);
        }
        catch (Exception exception) {
            throw new InterpreterException(exception);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Level logLevel = Level.WARNING;
        FactoryInterface factory = new InterpreterFactory();
        try {
            Properties properties = new Properties();
            properties.load(URLResource.getResourceAsStream((String)"/interpreter.properties"));
            logLevel = Level.parse(properties.getProperty("interpreter.logLevel"));
            Logger.getLogger("nl.tudelft.simulation.dsol.interpreter").setLevel(logLevel);
            Class<?> factoryClass = Class.forName(properties.getProperty("interpreter.operation.factory"));
            if (properties.getProperty("interpreter.operation.oracle") != null) {
                InterpreterOracleInterface oracle = (InterpreterOracleInterface)Class.forName(properties.getProperty("interpreter.operation.oracle")).newInstance();
                factory = (FactoryInterface)factoryClass.getConstructor(class$nl$tudelft$simulation$dsol$interpreter$operations$custom$InterpreterOracleInterface == null ? (class$nl$tudelft$simulation$dsol$interpreter$operations$custom$InterpreterOracleInterface = Interpreter.class$("nl.tudelft.simulation.dsol.interpreter.operations.custom.InterpreterOracleInterface")) : class$nl$tudelft$simulation$dsol$interpreter$operations$custom$InterpreterOracleInterface).newInstance(oracle);
            } else {
                factory = (FactoryInterface)factoryClass.newInstance();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        nl.tudelft.simulation.logger.Logger.setLogLevel((Level)logLevel);
        Interpreter.setFactory(factory);
    }
}

