/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter;

import nl.tudelft.simulation.dsol.interpreter.LocalVariable;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.Operation;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.classfile.MethodDescriptor;

public class Frame
implements Cloneable {
    protected Constant[] constantPool = null;
    protected LocalVariable[] localVariables = null;
    protected OperandStack operandStack = null;
    private boolean paused = false;
    private int returnPosition = 0;
    private Operation[] operations = null;
    private MethodDescriptor methodDescriptor;

    public Frame(Constant[] constantPool, LocalVariable[] localVariables, Operation[] operations, OperandStack stack, MethodDescriptor methodDescriptor) {
        this.constantPool = constantPool;
        this.localVariables = localVariables;
        this.operations = operations;
        this.operandStack = stack;
        this.methodDescriptor = methodDescriptor;
    }

    public Constant[] getConstantPool() {
        return this.constantPool;
    }

    public LocalVariable[] getLocalVariables() {
        return this.localVariables;
    }

    public int getReturnPosition() {
        return this.returnPosition;
    }

    public Operation[] getOperations() {
        return this.operations;
    }

    public void setReturnPosition(int returnPosition) {
        this.returnPosition = returnPosition;
    }

    public MethodDescriptor getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public OperandStack getOperandStack() {
        return this.operandStack;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public Object clone() {
        LocalVariable[] variables = new LocalVariable[this.localVariables.length];
        for (int i = 0; i < variables.length; ++i) {
            variables[i] = (LocalVariable)this.localVariables[i].clone();
        }
        OperandStack newStack = (OperandStack)this.operandStack.clone();
        Frame frame = new Frame(this.constantPool, variables, this.operations, newStack, this.methodDescriptor);
        return frame;
    }

    public String toString() {
        String result = "\n--- " + super.toString() + "---\n";
        result = result + "method:" + this.methodDescriptor.getMethod() + "\n";
        result = result + "invoker:" + this.localVariables[0].getValue() + "\n";
        return result;
    }
}

