/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.stat.support;

import dm.jdbc.stat.support.StatViewServlet;
import dm.jdbc.util.StringUtil;
import java.lang.instrument.Instrumentation;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class WebServer {
    private Server server;

    public static WebServer getInstance() {
        return WebServerHolder.instance;
    }

    public void startup(int port) {
        if (port > 0 && this.server == null) {
            try {
                this.server = new Server(port);
                ServletContextHandler context = new ServletContextHandler(1);
                context.setContextPath("/dmjdbc");
                this.server.setHandler((Handler)context);
                context.addServlet(new ServletHolder((Servlet)new StatViewServlet()), "/*");
                this.server.start();
            }
            catch (Exception e) {
                this.server = null;
                e.printStackTrace();
            }
        }
    }

    public boolean isStartup() {
        return this.server != null && this.server.isStarted();
    }

    protected void beforeExit() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public static void main(String[] args) throws Exception {
        WebServer.getInstance().startup(Integer.parseInt(args[0]));
        System.out.println("Web server startup...");
    }

    public static void premain(String agentArgs, Instrumentation inst) throws Exception {
        int port = 8080;
        try {
            if (StringUtil.isNotEmpty(agentArgs)) {
                port = Integer.parseInt(agentArgs);
            }
        }
        catch (Exception e) {
            throw new Exception("Invalid web server port!");
        }
        WebServer.getInstance().startup(port);
        System.out.println("Web server startup...");
    }

    private static class WebServerHolder {
        private static final WebServer instance = new WebServer();

        private WebServerHolder() {
        }
    }
}

