/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.rowset;

import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbResultSetMetaData_bs;
import dm.jdbc.rowset.DmdbCachedRowSet_bs;
import dm.jdbc.rowset.DmdbRow;
import java.sql.SQLException;

public class DmdbCachedRowSetWriterInner {
    private StringBuffer m_updateCommand = null;
    private StringBuffer m_insertCommand = null;
    private StringBuffer m_deleteCommand = null;
    private int m_columnCount = 0;
    private String m_tabName = "";
    private DmdbResultSetMetaData_bs m_rsmd = null;
    private DmdbPreparedStatement_bs m_updateStmt = null;
    private DmdbPreparedStatement_bs m_insertStmt = null;
    private DmdbPreparedStatement_bs m_deleteStmt = null;
    private DmdbConnection_bs m_conn = null;

    private void initialize(DmdbCachedRowSet_bs caller) throws SQLException {
        this.m_rsmd = caller.getMetaDataInner();
        this.m_columnCount = this.m_rsmd.getColumnCount();
        this.m_conn = caller.getConnectionInner();
        this.m_tabName = caller.getTableName().toUpperCase();
        this.m_updateCommand = new StringBuffer("UPDATE " + this.m_tabName + " SET ");
        this.m_insertCommand = new StringBuffer("INSERT INTO " + this.m_tabName + "(");
        this.m_deleteCommand = new StringBuffer("DELETE FROM " + this.m_tabName + " WHERE ");
        int i = 0;
        while (i < this.m_columnCount) {
            if (i > 0) {
                this.m_updateCommand.append(" , ");
                this.m_insertCommand.append(" , ");
            }
            this.m_updateCommand.append(String.valueOf(this.m_rsmd.getColumnName(i + 1)) + " = ?");
            this.m_insertCommand.append(this.m_rsmd.getColumnName(i + 1));
            ++i;
        }
        this.m_insertCommand.append(") VALUES(");
        this.m_updateCommand.append(" WHERE ");
        int j = 0;
        while (j < this.m_columnCount) {
            if (j > 0) {
                this.m_insertCommand.append(",");
                this.m_updateCommand.append(" AND ");
                this.m_deleteCommand.append(" AND ");
            }
            this.m_insertCommand.append("?");
            this.m_updateCommand.append(String.valueOf(this.m_rsmd.getColumnName(j + 1)) + "= ?");
            this.m_deleteCommand.append(String.valueOf(this.m_rsmd.getColumnName(j + 1)) + "= ?");
            ++j;
        }
        this.m_insertCommand.append(")");
        this.m_insertStmt = this.m_conn.prepareStatement(this.m_insertCommand.substring(0, this.m_insertCommand.length()));
        this.m_updateStmt = this.m_conn.prepareStatement(this.m_updateCommand.substring(0, this.m_updateCommand.length()));
        this.m_deleteStmt = this.m_conn.prepareStatement(this.m_deleteCommand.substring(0, this.m_deleteCommand.length()));
    }

    private boolean insertRow(DmdbRow row) throws SQLException {
        this.m_insertStmt.clearParameters();
        int i = 0;
        while (i < this.m_columnCount) {
            Object obj = row.getColumn(i);
            if (obj == null) {
                this.m_insertStmt.setNull(i + 1, this.m_rsmd.getColumnType(i + 1));
            } else {
                this.m_insertStmt.setObject(i + 1, obj);
            }
            ++i;
        }
        return 1 == this.m_insertStmt.executeUpdate();
    }

    private boolean updateRow(DmdbRow row) throws SQLException {
        if (row.isOriginalWithNull()) {
            return this.updateWithNull(row);
        }
        return this.updateNonNull(row);
    }

    private boolean updateWithNull(DmdbRow row) throws SQLException {
        StringBuffer updateSql = new StringBuffer("UPDATE " + this.m_tabName + " SET ");
        StringBuffer updateSqlTail = new StringBuffer(" WHERE ");
        int[] tailCols = new int[this.m_columnCount];
        int tailCnt = this.m_columnCount;
        int i = 0;
        while (i < this.m_columnCount) {
            if (i > 0) {
                updateSql.append(" , ");
                updateSqlTail.append(" AND ");
            }
            updateSql.append(String.valueOf(this.m_rsmd.getColumnName(i + 1)) + " = ?");
            updateSqlTail.append(this.m_rsmd.getColumnName(i + 1));
            if (row.isOriginalNull(i)) {
                tailCols[i] = -1;
                updateSqlTail.append(" IS NULL ");
            } else {
                tailCols[i] = ++tailCnt;
                updateSqlTail.append(" = ? ");
            }
            ++i;
        }
        updateSql.append(updateSqlTail);
        DmdbPreparedStatement_bs pstmt = this.m_conn.prepareStatement(updateSql.substring(0, updateSql.length()));
        int i2 = 0;
        while (i2 < this.m_columnCount) {
            Object obj;
            Object orgObj = row.getColumn(i2);
            Object object = obj = row.isColumnChanged(i2) ? row.getChangedColumn(i2) : orgObj;
            if (obj == null) {
                pstmt.setNull(i2 + 1, this.m_rsmd.getColumnType(i2 + 1));
            } else {
                pstmt.setObject(i2 + 1, obj);
            }
            if (tailCols[i2] != -1) {
                pstmt.setObject(tailCols[i2], orgObj);
            }
            ++i2;
        }
        boolean sus = 1 == pstmt.executeUpdate();
        pstmt.close();
        updateSql = null;
        updateSqlTail = null;
        return sus;
    }

    private boolean updateNonNull(DmdbRow row) throws SQLException {
        int i = 0;
        while (i < this.m_columnCount) {
            Object obj;
            Object orgObj = row.getColumn(i);
            Object object = obj = row.isColumnChanged(i) ? row.getChangedColumn(i) : orgObj;
            if (obj == null) {
                this.m_updateStmt.setNull(i + 1, this.m_rsmd.getColumnType(i + 1));
            } else {
                this.m_updateStmt.setObject(i + 1, obj);
            }
            this.m_updateStmt.setObject(this.m_columnCount + i + 1, orgObj);
            ++i;
        }
        return 1 == this.m_updateStmt.executeUpdate();
    }

    private boolean deleteRow(DmdbRow row) throws SQLException {
        if (row.isOriginalWithNull()) {
            return this.deleteWithNull(row);
        }
        return this.deleteNonNull(row);
    }

    private boolean deleteWithNull(DmdbRow row) throws SQLException {
        StringBuffer deleteSql = new StringBuffer("DELETE FROM " + this.m_tabName + " WHERE ");
        int[] tailCols = new int[this.m_columnCount];
        int tailCnt = 0;
        int i = 0;
        while (i < this.m_columnCount) {
            if (i > 0) {
                deleteSql.append(" AND ");
            }
            if (row.isOriginalNull(i)) {
                deleteSql.append(String.valueOf(this.m_rsmd.getColumnName(i + 1)) + " IS NULL ");
                tailCols[i] = -1;
            } else {
                deleteSql.append(String.valueOf(this.m_rsmd.getColumnName(i + 1)) + " = ? ");
                tailCols[i] = ++tailCnt;
            }
            ++i;
        }
        DmdbPreparedStatement_bs pstmt = this.m_conn.prepareStatement(deleteSql.substring(0, deleteSql.length()));
        int i2 = 0;
        while (i2 < this.m_columnCount) {
            if (tailCols[i2] != -1) {
                pstmt.setObject(tailCols[i2], row.getColumn(i2));
            }
            ++i2;
        }
        boolean sus = 1 == pstmt.executeUpdate();
        pstmt.close();
        pstmt = null;
        deleteSql = null;
        return sus;
    }

    private boolean deleteNonNull(DmdbRow row) throws SQLException {
        int i = 0;
        while (i < this.m_columnCount) {
            this.m_deleteStmt.setObject(i + 1, row.getColumn(i));
            ++i;
        }
        return 1 == this.m_deleteStmt.executeUpdate();
    }

    private void release() throws SQLException {
        this.m_insertCommand = null;
        if (this.m_insertStmt != null && !this.m_insertStmt.isClosed()) {
            this.m_insertStmt.close();
            this.m_insertStmt = null;
        }
        this.m_updateCommand = null;
        if (this.m_updateStmt != null && !this.m_updateStmt.isClosed()) {
            this.m_updateStmt.close();
            this.m_updateStmt = null;
        }
        this.m_deleteCommand = null;
        if (this.m_deleteStmt != null && !this.m_deleteStmt.isClosed()) {
            this.m_deleteStmt.close();
            this.m_deleteStmt = null;
        }
        this.m_columnCount = 0;
        this.m_rsmd = null;
        this.m_tabName = "";
    }

    public boolean writeData(DmdbCachedRowSet_bs caller) throws SQLException {
        this.initialize(caller);
        if (this.m_columnCount < 1) {
            this.release();
            return true;
        }
        boolean showDeleted = caller.getShowDeleted();
        if (this.m_conn.getAutoCommit()) {
            this.m_conn.setAutoCommit(false);
        }
        caller.setShowDeleted(true);
        caller.beforeFirst();
        boolean insertRs = true;
        boolean updateRs = true;
        boolean deleteRs = true;
        while (caller.next()) {
            DmdbRow row;
            if (caller.rowInserted()) {
                if (caller.rowDeleted()) continue;
                row = caller.getCurrentRow();
                insertRs = this.insertRow(row) && insertRs;
                continue;
            }
            if (caller.rowUpdated()) {
                row = caller.getCurrentRow();
                updateRs = this.updateRow(row) && updateRs;
                continue;
            }
            if (!caller.rowDeleted()) continue;
            row = caller.getCurrentRow();
            boolean bl = deleteRs = this.deleteRow(row) && deleteRs;
        }
        if (!(insertRs && updateRs && deleteRs)) {
            this.m_conn.rollback();
        } else {
            this.m_conn.commit();
            caller.setOriginal();
        }
        caller.setShowDeleted(showDeleted);
        this.release();
        if (!caller.keepConnecting() && this.m_conn != null && !this.m_conn.isClosed()) {
            this.m_conn.close();
            this.m_conn = null;
        }
        return true;
    }
}

