/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.processor;

import dm.jdbc.dbaccess.DmdbSwitch;
import dm.jdbc.desc.DmServerInfo;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.desc.ServerGroup;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.processor.BaseThread;
import dm.jdbc.util.DmJdbcUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class LoadBalanceThread
extends BaseThread {
    private static LoadBalanceThread loadBalanceThread = null;
    private boolean stop = false;
    private static Map<String, ServerGroup> queue;

    private LoadBalanceThread() {
        super("LOAD-BALANCE-THREAD");
        queue = new HashMap<String, ServerGroup>();
    }

    public static synchronized void addServerGroup(DmdbConnection_bs conn) {
        if (loadBalanceThread == null) {
            loadBalanceThread = new LoadBalanceThread();
            loadBalanceThread.start();
        }
        if (!queue.containsKey(conn.getServerGroup().getName())) {
            ServerGroup serverGroup = conn.getServerGroup();
            serverGroup.setUserName(conn.getUser());
            serverGroup.setPassword(conn.getPassword());
            queue.put(serverGroup.getName(), serverGroup);
        }
    }

    public void run() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        while (!this.stop) {
            try {
                for (ServerGroup serverGroup : queue.values()) {
                    if (serverGroup == null) continue;
                    int[] sessCounts = new int[serverGroup.getSessCounts().length];
                    int i = 0;
                    while (i < sessCounts.length) {
                        DmServerInfo server = serverGroup.getSvrList().get(i);
                        Future<Integer> future = executor.submit(new SessCountGetTask(server, serverGroup.getUserName(), serverGroup.getPassword()));
                        try {
                            sessCounts[i] = future.get(10L, TimeUnit.SECONDS);
                        }
                        catch (Throwable e) {
                            sessCounts[i] = Integer.MAX_VALUE;
                        }
                        ++i;
                    }
                    try {
                        serverGroup.lock();
                        serverGroup.setSessCounts(sessCounts);
                        serverGroup.setPlbTs(System.currentTimeMillis());
                    }
                    finally {
                        serverGroup.unLock();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(DmSvcConf.loadBalanceFreq);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SessCountGetTask
    implements Callable<Integer> {
        DmServerInfo server;
        String userName;
        String password;

        public SessCountGetTask(DmServerInfo server, String userName, String password) {
            this.server = server;
            this.userName = userName;
            this.password = password;
        }

        @Override
        public Integer call() throws Exception {
            int retSessCount = Integer.MAX_VALUE;
            DmdbConnection_bs conn = this.server.getConn();
            ResultSet rs = null;
            int reconnCount = 1;
            do {
                block22: {
                    try {
                        if (conn != null) break block22;
                        conn = DmJdbcUtil.createConnection(this.server.getSvrName(), this.server.hasPort() ? String.valueOf(this.server.getSvrPort()) : String.valueOf(5236), this.userName, this.password, null);
                        if (DmdbSwitch.validServerMode(conn.getLoginMode(), conn)) {
                            this.server.setConn(conn);
                            this.server.setLastConnSucc(true);
                            break block22;
                        }
                        this.server.setConn(null);
                        this.server.setLastConnSucc(false);
                    }
                    catch (Exception e) {
                        this.server.setConn(null);
                        this.server.setLastConnSucc(false);
                    }
                    break;
                }
                try {
                    rs = DmJdbcUtil.executeQuery(conn, "select count(1) from sys.v$sessions where sf_get_ep_seqno(rowid)=sf_get_self_ep_seqno();");
                    if (!rs.next()) break;
                    retSessCount = rs.getInt(1);
                    break;
                }
                catch (SQLException e) {
                    if (e.getErrorCode() != 6001) break;
                    conn = null;
                    this.server.setConn(null);
                }
                catch (Exception exception) {
                    break;
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            } while (--reconnCount >= 0);
            return retSessCount;
        }
    }
}

