/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.pool;

import dm.jdbc.driver.DmDriver_bs;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class DmdbDataSource_bs
implements DataSource,
Serializable,
Referenceable {
    protected static DmDriver_bs DmDriver = null;
    protected boolean explicitUrl = false;
    protected String url = null;
    protected String hostName = "localhost";
    protected int port = 5236;
    protected String databaseName = "";
    protected String user = null;
    protected String password = null;
    protected PrintWriter logWriter = null;
    protected int loginTimeout = 0;
    private static final long serialVersionUID = 1L;

    static {
        try {
            DmDriver = (DmDriver_bs)Class.forName("dm.jdbc.driver.DmDriver_bs").newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can not load Driver class dm.jdbc.driver.DmDriver");
        }
    }

    public synchronized Reference getReference() throws NamingException {
        String factoryName = "dm.jdbc.pool.DmdbDataSourceFactory";
        Reference ref = new Reference(this.getClass().getName(), factoryName, null);
        ref.add(new StringRefAddr("host", this.getServer()));
        ref.add(new StringRefAddr("port", String.valueOf(this.getPort())));
        if (this.url != null) {
            ref.add(new StringRefAddr("url", this.url));
        }
        ref.add(new StringRefAddr("user", this.getUser()));
        ref.add(new StringRefAddr("password", this.password));
        ref.add(new StringRefAddr("dbname", this.getDatabase()));
        return ref;
    }

    public String getURL() {
        if (!this.explicitUrl) {
            String builtUrl = "jdbc:dm://";
            String database = this.getDatabase();
            builtUrl = database == null || database == "" ? String.valueOf(builtUrl) + this.getServer() + ":" + this.getPort() : String.valueOf(builtUrl) + this.getServer() + ":" + this.getPort() + "/" + this.getDatabase();
            return builtUrl;
        }
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
        this.explicitUrl = true;
    }

    public String getServer() {
        return this.hostName;
    }

    public void setServer(String server) {
        this.hostName = server;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.databaseName;
    }

    public void setDatabase(String database) {
        this.databaseName = database;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public Connection getConnection(String userID, String password) throws SQLException {
        Properties props = new Properties();
        if (userID == null) {
            userID = "SYSDBA";
        }
        if (password == null) {
            password = "SYSDBA";
        }
        props.put("user", userID);
        props.put("password", password);
        return this.getConnection(props);
    }

    protected Connection getConnection(Properties props) throws SQLException {
        String jdbcUrlToUse = null;
        if (!this.explicitUrl) {
            StringBuffer jdbcUrl = new StringBuffer("jdbc:dm://");
            if (this.hostName != null) {
                jdbcUrl.append(this.hostName);
            }
            jdbcUrl.append(":");
            jdbcUrl.append(this.port);
            jdbcUrl.append("/");
            if (this.databaseName != null) {
                jdbcUrl.append(this.databaseName);
            }
            jdbcUrlToUse = jdbcUrl.toString();
        } else {
            jdbcUrlToUse = this.url;
        }
        return DmDriver.connect(jdbcUrlToUse, props);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }
}

