/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.log;

import dm.jdbc.log.LogBuffer;
import dm.jdbc.log.LogFlusher;
import java.util.concurrent.locks.ReentrantLock;

public class LogWriter {
    private LogBuffer buffer;
    private ReentrantLock lock = new ReentrantLock();
    private LogFlusher flusher;

    private LogWriter() {
        this.buffer = LogBuffer.borrowBuffer();
        this.flusher = LogFlusher.getInstance();
        this.flusher.start();
    }

    public static LogWriter getInstance() {
        return LoggerHolder.instance;
    }

    public void write(String log) {
        try {
            this.lock.lock();
            if (this.buffer.isFull()) {
                this.flusher.submit(this.buffer);
                this.buffer = LogBuffer.borrowBuffer();
            }
            this.buffer.log(log);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doSubmitBuffer() {
        try {
            this.lock.lock();
            if (this.buffer.getOffset() > 0) {
                this.flusher.submit(this.buffer);
                this.buffer = LogBuffer.borrowBuffer();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public static void submitBuffer() {
        LogWriter.getInstance().doSubmitBuffer();
    }

    public static void main(String[] args) {
        LogWriter logger = LogWriter.getInstance();
        int i = 0;
        while (i < 500) {
            logger.write("select " + i + " from dual;");
            ++i;
        }
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LogWriter.submitBuffer();
    }

    /* synthetic */ LogWriter(LogWriter logWriter) {
        this();
    }

    private static class LoggerHolder {
        private static final LogWriter instance = new LogWriter(null);

        private LoggerHolder() {
        }
    }
}

