/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.dbaccess.Auth;
import dm.jdbc.dbaccess.AuthInfo;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmCipherEncryptDLL;
import dm.jdbc.dbaccess.DmMsgRecv;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.dbaccess.MsgSecurity;
import dm.jdbc.dbaccess.SymmCipherDesc;
import dm.jdbc.dbaccess.ssl.MakeSSLSocket;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.jzlib.ZlibUtil;
import dm.jdbc.util.IPAddressUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.sql.SQLException;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.interfaces.DHPublicKey;

public class DbAccessPure {
    private OutputStream dmOutput = null;
    private InputStream dmInput = null;
    private Socket dmSocket = null;
    private int netPort = 5236;
    private String hostName = null;
    private Properties props = null;
    private int netPacketSize = 8192;
    private AuthInfo m_kerberosAuth = null;
    private int connTimeout = 0;
    private KeyPair clientKeyPair = null;
    private Cipher encryptCipher = null;
    private Cipher decryptCipher = null;
    private int msgEncryptType = -1;
    private int isLocal = -1;
    private byte[] sessionKey;
    private static boolean hasInitCipher = false;
    private int hashType = -1;
    private int hashSize;

    public DbAccessPure(String host, int port, Properties props, int connTimeout) throws IOException {
        this.netPort = port;
        this.setHostName(host);
        this.props = props;
        this.connTimeout = connTimeout;
        this.changeSocket(this.createSocket(this.hostName, this.netPort, this.connTimeout));
    }

    public DbAccessPure(DmdbConnection_bs conn, String host, int port) throws IOException {
        this.netPort = port;
        this.setHostName(host);
        this.props = conn.getProperties();
        this.connTimeout = conn.getConnectTimeout();
        this.changeSocket(this.createSocket(this.hostName, this.netPort, this.connTimeout));
    }

    public void tryEnableSSL(boolean useSSLSocket) throws IOException, SQLException {
        MakeSSLSocket ssl = new MakeSSLSocket();
        ssl.convert(this, this.props, useSSLSocket);
    }

    public synchronized DmMsgRecv access(DmMsgSend sendMsg, int compress) throws SQLException, IOException {
        this.send(sendMsg, compress);
        return this.readPacket(compress);
    }

    public void setSocketInfo(String host, String port) throws UnknownHostException, IOException {
        this.setHostName(host);
        this.netPort = Integer.parseInt(port);
        this.changeSocket(this.createSocket(this.hostName, this.netPort, this.connTimeout));
    }

    public void changeSocket(Socket socket) throws IOException {
        this.dmSocket = socket;
        this.dmSocket.setTcpNoDelay(true);
        this.dmSocket.setKeepAlive(true);
        this.dmInput = new BufferedInputStream(this.dmSocket.getInputStream(), this.netPacketSize);
        this.dmOutput = new BufferedOutputStream(this.dmSocket.getOutputStream(), this.netPacketSize);
    }

    public final Socket getSocket() {
        return this.dmSocket;
    }

    public final String getHostName() {
        return this.hostName;
    }

    public final void setHostName(String host) {
        this.hostName = host;
        this.isLocal = -1;
    }

    private boolean getIsLocal() {
        if (this.isLocal == -1 && this.hostName != null && this.hostName.length() > 0) {
            int n = this.isLocal = DbAccessPure.isLocalHost(this.hostName) ? 1 : 0;
        }
        return this.isLocal == 1;
    }

    private static boolean isLocalHost(String host) {
        String localhostIP;
        String host2;
        if ("localhost".equalsIgnoreCase(host) || "127.0.0.1".equals(host) || "::1".equals(host)) {
            return true;
        }
        try {
            host2 = InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException x) {
            host2 = host;
        }
        try {
            localhostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException x) {
            localhostIP = null;
        }
        return host2.equalsIgnoreCase(localhostIP);
    }

    public final int getPortNumber() {
        return this.netPort;
    }

    public final void close() {
        this.clientKeyPair = null;
        this.encryptCipher = null;
        this.decryptCipher = null;
        this.msgEncryptType = -1;
        try {
            if (this.dmInput != null) {
                this.dmInput.close();
                this.dmInput = null;
            }
        }
        catch (Exception Ex) {
            this.dmInput = null;
        }
        try {
            if (this.dmOutput != null) {
                this.dmOutput.close();
                this.dmOutput = null;
            }
        }
        catch (Exception Ex) {
            this.dmOutput = null;
        }
        try {
            if (this.dmSocket != null) {
                this.dmSocket.close();
                this.dmSocket = null;
            }
        }
        catch (Exception Ex) {
            this.dmSocket = null;
        }
    }

    private final DmMsgRecv readPacket_only() throws IOException {
        DmMsgRecv msg = new DmMsgRecv();
        int ret_len = this.readOnce(this.dmInput, msg.getBuffer(), 0, 32640);
        if (ret_len <= 0) {
            throw new IOException();
        }
        long msgLen = msg.res_get_len();
        if ((msgLen += 64L) > (long)msg.getBufLength()) {
            msg.setBuffer((int)msgLen);
        }
        if ((long)ret_len < msgLen) {
            this.readFully(this.dmInput, msg.getBuffer(), ret_len, (int)(msgLen - (long)ret_len));
        }
        return msg;
    }

    private final DmMsgRecv readPacket(int ifCompress) throws IOException, SQLException {
        DmMsgRecv msg = this.readPacket_only();
        if (!msg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if (this.msgEncryptType != -1 && msg.res_get_len() != 0L) {
            int srcLen = (int)msg.res_get_len();
            byte[] tmp = new byte[srcLen];
            System.arraycopy(msg.getBuffer(), 64, tmp, 0, srcLen);
            byte[] decomBuf = this.symmetricDecrypto(tmp, srcLen, true);
            int desLen = decomBuf.length;
            if (desLen + 64 > msg.getBufLength()) {
                msg.setBuffer(desLen + 64);
            }
            msg.res_set_len(desLen);
            System.arraycopy(decomBuf, 0, msg.getBuffer(), 64, desLen);
        }
        long resLen = msg.res_get_len();
        if (ifCompress == 1 && resLen > 0L || ifCompress == 2 && msg.res_get_compress() == 1) {
            byte[] tmp = new byte[(int)resLen - 4];
            System.arraycopy(msg.getBuffer(), 68, tmp, 0, tmp.length);
            byte[] decomBuf = ZlibUtil.uncompress(tmp);
            int desLen = decomBuf.length;
            if (desLen + 64 > msg.getBufLength()) {
                msg.setBuffer(desLen + 64);
            }
            msg.res_set_len(desLen);
            System.arraycopy(decomBuf, 0, msg.getBuffer(), 64, desLen);
        }
        return msg;
    }

    private final int readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < len) {
            int count = in.read(b, off + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
        return n;
    }

    private final int readOnce(InputStream in, byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int count = in.read(b, off, len);
        return count;
    }

    private final DmMsgSend pre_send(DmMsgSend msg, int ifCompress) throws SQLException {
        int offset;
        byte[] tmp;
        int reqLen = msg.req_get_len();
        if (ifCompress == 1 && reqLen > 0 || ifCompress == 2 && !this.getIsLocal() && reqLen > 8192) {
            tmp = msg.getFromOffsetWithLen(64, reqLen);
            byte[] comBuf = ZlibUtil.compress(tmp);
            offset = 64;
            msg.setInt(reqLen, offset);
            msg.req_set_len(comBuf.length + 4);
            msg.req_set_compress((byte)1);
            msg.replaceFromOffset(offset += 4, comBuf);
        } else {
            msg.req_set_compress((byte)0);
        }
        reqLen = msg.req_get_len();
        if (this.msgEncryptType != -1 && reqLen != 0) {
            tmp = msg.getFromOffsetWithLen(64, reqLen);
            byte[] encBuf = this.symmetricEncrypto(tmp, reqLen, true);
            offset = 64;
            msg.req_set_len(encBuf.length);
            msg.replaceFromOffset(offset, encBuf);
        }
        msg.setCRC(msg.calculateCRC());
        return msg;
    }

    private final void send(DmMsgSend msgIn, int compress) throws IOException, SQLException {
        DmMsgSend msgExtend = this.pre_send(msgIn, compress);
        msgExtend.resetListPointer();
        DmMsgSend.BufferNode node = msgExtend.getFirstNode();
        while (node != null) {
            if (node.getBufferLen() != 0) {
                this.dmOutput.write(node.buffer, 0, node.getBufferLen());
                this.dmOutput.flush();
            }
            if (node == msgExtend.getBufferList().getTail()) break;
            node = msgExtend.getNextNode();
        }
    }

    public final int getNetPacketSize() {
        return this.netPacketSize;
    }

    public AuthInfo initAuthInfo(String kerberosUser, String loginPath, int authType) throws SQLException {
        if (this.m_kerberosAuth != null) {
            this.m_kerberosAuth = null;
        }
        Auth auth = null;
        try {
            if (loginPath != null && loginPath.length() > 0) {
                System.setProperty("java.security.auth.login.config", loginPath);
            }
            if (kerberosUser != null && kerberosUser.length() > 0) {
                System.setProperty("sun.security.krb5.principal", String.valueOf(kerberosUser) + "@DAMENG.ORG");
            }
            auth = new Auth(this.dmSocket.getInetAddress().getCanonicalHostName(), authType);
        }
        catch (UnknownHostException e1) {
            DBError.throwSQLException(6063);
        }
        this.m_kerberosAuth = auth.getAuthInfo();
        return this.m_kerberosAuth;
    }

    public AuthInfo getAuthInfo() {
        return this.m_kerberosAuth;
    }

    public void reset() throws SQLException {
        try {
            if (this.dmSocket != null) {
                this.dmSocket.close();
            }
        }
        catch (IOException ioex) {
            throw new SQLException(ioex.getMessage());
        }
    }

    private Socket createSocket(String hostName, int netPort, int timeOut) throws IOException {
        byte[] addr = IPAddressUtil.textToNumericFormatV4(hostName);
        if (addr == null) {
            addr = IPAddressUtil.textToNumericFormatV6(hostName);
        }
        Socket socket = new Socket();
        InetSocketAddress socketAddress = null;
        if (addr != null) {
            InetAddress address = InetAddress.getByAddress(hostName, addr);
            socketAddress = new InetSocketAddress(address, netPort);
        } else {
            socketAddress = new InetSocketAddress(hostName, netPort);
        }
        socket.connect(socketAddress, timeOut);
        return socket;
    }

    public byte[] getClientPubKey() throws SQLException {
        if (this.clientKeyPair == null) {
            this.clientKeyPair = MsgSecurity.newClientKeyPair();
        }
        return MsgSecurity.bn2Bytes(((DHPublicKey)this.clientKeyPair.getPublic()).getY(), 64);
    }

    public PrivateKey getClientPrivKey() throws SQLException {
        if (this.clientKeyPair == null) {
            this.clientKeyPair = MsgSecurity.newClientKeyPair();
        }
        return this.clientKeyPair.getPrivate();
    }

    public final void genMsgCiphers(int msgCipherType, byte[] tempSessionKey, String cipherPath) throws SQLException {
        byte[] sessionKey = null;
        SymmCipherDesc cipherDesc = null;
        if (-1 == msgCipherType) {
            this.encryptCipher = null;
            this.decryptCipher = null;
            return;
        }
        if (msgCipherType < 5000) {
            cipherDesc = new SymmCipherDesc(msgCipherType);
            int keySize = cipherDesc.getKeyLength();
            if (256 == cipherDesc.getAlgorithmType()) {
                keySize += 8;
            }
            sessionKey = new byte[keySize];
            System.arraycopy(tempSessionKey, 0, sessionKey, 0, keySize);
            if (256 == cipherDesc.getAlgorithmType()) {
                System.arraycopy(tempSessionKey, 0, sessionKey, keySize - 8, 8);
            }
            try {
                this.encryptCipher = MsgSecurity.newCipher(1, cipherDesc, sessionKey);
                this.decryptCipher = MsgSecurity.newCipher(2, cipherDesc, sessionKey);
            }
            catch (Exception e) {
                this.encryptCipher = null;
                this.decryptCipher = null;
                DBError.throwSQLException(6061);
            }
        } else {
            this.sessionKey = tempSessionKey;
            this.encryptCipher = null;
            this.decryptCipher = null;
            if (!hasInitCipher) {
                if (DmCipherEncryptDLL.initCipherEncrypt(cipherPath) <= 0) {
                    DBError.throwSQLException(6061);
                } else {
                    hasInitCipher = true;
                }
            }
        }
    }

    protected byte[] symmetricEncrypto(byte[] byteSource, int length, boolean gen_digest) throws SQLException {
        try {
            byte[] ret;
            if (this.msgEncryptType >= 5000 && hasInitCipher) {
                ret = DmCipherEncryptDLL.cipherEncrypt(this.msgEncryptType, this.sessionKey, byteSource);
                if (ret == null) {
                    DBError.throwSQLException(6071);
                }
            } else {
                ret = this.encryptCipher.doFinal(byteSource, 0, length);
            }
            if (!gen_digest) {
                return ret;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(ret);
            baos.write(this.genMessageDigest(this.hashType, byteSource));
            return baos.toByteArray();
        }
        catch (Exception e) {
            DBError.throwSQLException(6071);
            return new byte[0];
        }
    }

    private byte[] symmetricDecrypto(byte[] byteSource, int length, boolean gen_digest) throws SQLException {
        byte[] digest = null;
        byte[] plain_text = null;
        try {
            byte[] msg_digest;
            if (gen_digest) {
                digest = new byte[this.hashSize];
                System.arraycopy(byteSource, length - this.hashSize, digest, 0, this.hashSize);
                plain_text = new byte[length - this.hashSize];
                System.arraycopy(byteSource, 0, plain_text, 0, length - this.hashSize);
            } else {
                plain_text = byteSource;
            }
            if (this.msgEncryptType >= 5000 && hasInitCipher) {
                if ((plain_text = DmCipherEncryptDLL.cipherDecrypt(this.msgEncryptType, this.sessionKey, plain_text)) == null) {
                    DBError.throwSQLException(6072);
                }
            } else {
                plain_text = this.decryptCipher.doFinal(plain_text);
            }
            if (gen_digest && !this.checkMessageDigest(msg_digest = this.genMessageDigest(this.hashType, plain_text), digest)) {
                DBError.throwSQLException(6072);
            }
            return plain_text;
        }
        catch (Exception e) {
            DBError.throwSQLException(6072);
            return new byte[0];
        }
    }

    private final byte[] genMessageDigest(int algorithm, byte[] msg_text) throws IOException, SQLException {
        byte[] msg_digest = null;
        if (algorithm >= 5000 && hasInitCipher) {
            msg_digest = DmCipherEncryptDLL.cipherHash(algorithm, msg_text);
        } else {
            MessageDigest md = null;
            switch (algorithm) {
                case 4352: {
                    try {
                        md = MessageDigest.getInstance("MD5");
                        break;
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IOException();
                    }
                }
                default: {
                    DBError.throwSQLException("error digest type");
                }
            }
            if (md == null) {
                DBError.throwSQLException("get message digest fail");
            }
            md.reset();
            md.update(msg_text);
            msg_digest = md.digest();
        }
        if (msg_digest == null || msg_digest.length == 0 || msg_digest.length == 1 && msg_digest[0] == 0) {
            DBError.throwSQLException("get message digest fail");
        }
        return msg_digest;
    }

    private final boolean checkMessageDigest(byte[] msg_digest, byte[] digest) throws NoSuchAlgorithmException {
        if (digest.length != msg_digest.length) {
            return false;
        }
        int i = 0;
        while (i < digest.length) {
            if (digest[i] != msg_digest[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setMsgEncryptType(int msgEncryptType) {
        this.msgEncryptType = msgEncryptType;
    }

    public int getMsgEncryptType() {
        return this.msgEncryptType;
    }

    public void setHashType(int hashType) throws SQLException {
        this.hashType = hashType;
        if (hashType == 4352) {
            this.hashSize = 16;
        } else if (hashType != -1) {
            this.hashSize = DmCipherEncryptDLL.getHashSize(hashType);
            if (this.hashSize < 0) {
                DBError.throwSQLException(6061);
            }
        }
    }

    public int getHashType() {
        return this.hashType;
    }

    public String toString() {
        return String.valueOf(this.hostName) + ":" + this.netPort;
    }
}

