/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.binder;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.binder.DmBinder;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.sql.DmdbTimestamp;
import dm.sql.TypeDescriptor;
import java.sql.SQLException;
import java.util.Calendar;

public class DmByteBinder
extends DmBinder {
    public DmByteBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
    }

    void init() {
        this.recDType = 5;
        this.recPrec = 1;
        this.recScale = 0;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        Object obj = this.pstmt.getParamObject(irow, icol);
        String serverEncoding = this.pstmt.getConnection_bs().getServerEncoding();
        short dbTz = this.pstmt.getConnection_bs().getDbTz();
        short ltz = this.pstmt.getConnection_bs().getClientTz();
        TypeDescriptor typeDesc = this.paramsDesc[icol].getTypeDescriptor();
        byte[] ret = null;
        ret = this.isDiffParamObjectType() && !(obj instanceof Byte) ? this.castToDestType(obj, this.destDType, this.destPrec, this.destScale, serverEncoding, ltz, dbTz, typeDesc) : DmByteBinder.toDbBytes((Byte)obj, this.destDType, this.destPrec, this.destScale, serverEncoding, ltz, dbTz, this.defaultCalendar);
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(byte x, int destDType, int destPrec, int destScale, String serverEncoding, short ltz, short dbTz, Calendar defaultCalendar) throws SQLException {
        byte[] ret = null;
        if (DmdbType.isBFileType(destDType, destPrec, destScale)) {
            DBError.throwSQLException(6007);
        } else {
            switch (destDType) {
                case 3: 
                case 13: {
                    ret = Convertion.booleanToByteArray(x != 0);
                    break;
                }
                case 5: {
                    ret = Convertion.byteToByteArray(x);
                    break;
                }
                case 6: {
                    ret = Convertion.shortToByteArray(x);
                    break;
                }
                case 7: {
                    ret = Convertion.intToByteArray(x);
                    break;
                }
                case 8: {
                    ret = Convertion.longToByteArray(x);
                    break;
                }
                case 10: {
                    ret = Convertion.floatToByteArray(x);
                    break;
                }
                case 11: {
                    ret = Convertion.doubleToByteArray(x);
                    break;
                }
                case 9: {
                    ret = Convertion.BigDecimalToByteArray(String.valueOf(x), destPrec, destScale);
                    break;
                }
                case 0: 
                case 1: {
                    ret = Convertion.String_char_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                    break;
                }
                case 2: 
                case 19: {
                    ret = Convertion.String_varchar_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    ret = DmdbTimestamp.encodeByDateNumber(x, destDType, destScale, defaultCalendar, ltz, dbTz);
                    break;
                }
                default: {
                    DBError.throwSQLException(6007);
                }
            }
        }
        return ret;
    }
}

