/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.accessor;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.accessor.BaseAccessor;
import dm.jdbc.dbaccess.DBError;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleAccessor
extends BaseAccessor {
    @Override
    public boolean getBoolean() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? false : Double.longBitsToDouble(Convertion.eightByteToLong(this.byteValue)) != 0.0;
    }

    @Override
    public byte getByte() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return 0;
        }
        double result = Double.longBitsToDouble(Convertion.eightByteToLong(this.byteValue));
        if (result < -128.0 || result > 127.0) {
            DBError.throwSQLException(6004);
        }
        return (byte)result;
    }

    @Override
    public short getShort() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return 0;
        }
        double result = Double.longBitsToDouble(Convertion.eightByteToLong(this.byteValue));
        if (result < -32768.0 || result > 32767.0) {
            DBError.throwSQLException(6004);
        }
        return (short)result;
    }

    @Override
    public int getInt() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return 0;
        }
        double result = Double.longBitsToDouble(Convertion.eightByteToLong(this.byteValue));
        if (result < -2.147483648E9 || result > 2.147483647E9) {
            DBError.throwSQLException(6004);
        }
        return (int)result;
    }

    @Override
    public long getLong() throws SQLException {
        this.getByteArrayValue();
        if (this.wasNull) {
            return 0L;
        }
        double result = Double.longBitsToDouble(Convertion.eightByteToLong(this.byteValue));
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            DBError.throwSQLException(6004);
        }
        return (long)result;
    }

    @Override
    public float getFloat() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? 0.0f : (float)Double.longBitsToDouble(Convertion.eightByteToLong(this.byteValue));
    }

    @Override
    public double getDouble() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? 0.0 : Double.longBitsToDouble(Convertion.eightByteToLong(this.byteValue));
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? null : new BigDecimal(Double.longBitsToDouble(Convertion.eightByteToLong(this.byteValue)));
    }

    @Override
    public String getString() throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? null : String.valueOf(Double.longBitsToDouble(Convertion.eightByteToLong(this.byteValue)));
    }

    @Override
    public Object getObjectInner(Map<String, Class<?>> typeMap) throws SQLException {
        this.getByteArrayValue();
        return this.wasNull ? 0.0 : Double.longBitsToDouble(Convertion.eightByteToLong(this.byteValue));
    }
}

