/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.embedding.alloydb.index.query;

import dev.langchain4j.community.store.embedding.alloydb.index.query.QueryOptions;
import java.util.ArrayList;
import java.util.List;

public class ScaNNIndexQueryOptions
implements QueryOptions {
    private final Integer numLeavesToSearch;
    private final Integer preOrderingNumNeighbors;

    public ScaNNIndexQueryOptions(Builder builder) {
        this.numLeavesToSearch = builder.numLeavesToSearch;
        this.preOrderingNumNeighbors = builder.preOrderingNumNeighbors;
    }

    @Override
    public List<String> getParameterSettings() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(String.format("scann.num_leaves_to_search = %s", this.numLeavesToSearch));
        parameters.add(String.format("scann.pre_reordering_num_neighbors = %s", this.preOrderingNumNeighbors));
        return parameters;
    }

    public class Builder {
        private Integer numLeavesToSearch = 1;
        private Integer preOrderingNumNeighbors = -1;

        public Builder numLeavesToSearch(Integer numLeavesToSearch) {
            this.numLeavesToSearch = numLeavesToSearch;
            return this;
        }

        public Builder preOrderingNumNeighbors(Integer preOrderingNumNeighbors) {
            this.preOrderingNumNeighbors = preOrderingNumNeighbors;
            return this;
        }

        public ScaNNIndexQueryOptions build() {
            return new ScaNNIndexQueryOptions(this);
        }
    }
}

