/*
 * Decompiled with CFR 0.152.
 */
package com.zhuozhengsoft.base64;

import com.zhuozhengsoft.base64.BaseNCodec;
import com.zhuozhengsoft.base64.BaseNCodec$Context;
import com.zhuozhengsoft.base64.StringUtils;
import java.math.BigInteger;

public class Base64
extends BaseNCodec {
    private static byte[] a = new byte[]{13, 10};
    private static final byte[] b = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] c = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] d = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private final byte[] e;
    private final byte[] f = d;
    private final byte[] g;
    private final int h;
    private final int i;

    public Base64() {
        this(0);
    }

    public Base64(boolean bl) {
        this(76, a, bl);
    }

    public Base64(int n) {
        this(n, a);
    }

    public Base64(int n, byte[] byArray) {
        this(n, byArray, false);
    }

    public Base64(int n, byte[] byArray, boolean bl) {
        super(3, 4, n, byArray == null ? 0 : byArray.length);
        if (byArray != null) {
            if (this.containsAlphabetOrPad(byArray)) {
                String string = StringUtils.newStringUtf8(byArray);
                throw new IllegalArgumentException("lineSeparator must not contain base64 characters: [" + string + "]");
            }
            if (n > 0) {
                this.i = 4 + byArray.length;
                this.g = new byte[byArray.length];
                System.arraycopy(byArray, 0, this.g, 0, byArray.length);
            } else {
                this.i = 4;
                this.g = null;
            }
        } else {
            this.i = 4;
            this.g = null;
        }
        this.h = this.i - 1;
        this.e = bl ? c : b;
    }

    public boolean isUrlSafe() {
        return this.e == c;
    }

    @Override
    final void a(byte[] byArray, int n, int n2, BaseNCodec$Context baseNCodec$Context) {
        if (baseNCodec$Context.e) {
            return;
        }
        if (n2 < 0) {
            baseNCodec$Context.e = true;
            if (baseNCodec$Context.g == 0 && this.lineLength == 0) {
                return;
            }
            byte[] byArray2 = this.ensureBufferSize(this.i, baseNCodec$Context);
            int n3 = baseNCodec$Context.c;
            switch (baseNCodec$Context.g) {
                case 0: {
                    break;
                }
                case 1: {
                    byArray2[baseNCodec$Context.c++] = this.e[baseNCodec$Context.a >> 2 & 0x3F];
                    byArray2[baseNCodec$Context.c++] = this.e[baseNCodec$Context.a << 4 & 0x3F];
                    if (this.e != b) break;
                    byArray2[baseNCodec$Context.c++] = this.pad;
                    byArray2[baseNCodec$Context.c++] = this.pad;
                    break;
                }
                case 2: {
                    byArray2[baseNCodec$Context.c++] = this.e[baseNCodec$Context.a >> 10 & 0x3F];
                    byArray2[baseNCodec$Context.c++] = this.e[baseNCodec$Context.a >> 4 & 0x3F];
                    byArray2[baseNCodec$Context.c++] = this.e[baseNCodec$Context.a << 2 & 0x3F];
                    if (this.e != b) break;
                    byArray2[baseNCodec$Context.c++] = this.pad;
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible modulus " + baseNCodec$Context.g);
                }
            }
            baseNCodec$Context.f += baseNCodec$Context.c - n3;
            if (this.lineLength > 0 && baseNCodec$Context.f > 0) {
                System.arraycopy(this.g, 0, byArray2, baseNCodec$Context.c, this.g.length);
                baseNCodec$Context.c += this.g.length;
            }
            return;
        }
        for (int i = 0; i < n2; ++i) {
            int n4;
            byte[] byArray3 = this.ensureBufferSize(this.i, baseNCodec$Context);
            baseNCodec$Context.g = (baseNCodec$Context.g + 1) % 3;
            if ((n4 = byArray[n++]) < 0) {
                n4 += 256;
            }
            baseNCodec$Context.a = (baseNCodec$Context.a << 8) + n4;
            if (baseNCodec$Context.g != 0) continue;
            byArray3[baseNCodec$Context.c++] = this.e[baseNCodec$Context.a >> 18 & 0x3F];
            byArray3[baseNCodec$Context.c++] = this.e[baseNCodec$Context.a >> 12 & 0x3F];
            byArray3[baseNCodec$Context.c++] = this.e[baseNCodec$Context.a >> 6 & 0x3F];
            byArray3[baseNCodec$Context.c++] = this.e[baseNCodec$Context.a & 0x3F];
            baseNCodec$Context.f += 4;
            if (this.lineLength <= 0 || this.lineLength > baseNCodec$Context.f) continue;
            System.arraycopy(this.g, 0, byArray3, baseNCodec$Context.c, this.g.length);
            baseNCodec$Context.c += this.g.length;
            baseNCodec$Context.f = 0;
        }
    }

    @Override
    final void b(byte[] byArray, int n, int n2, BaseNCodec$Context baseNCodec$Context) {
        if (baseNCodec$Context.e) {
            return;
        }
        if (n2 < 0) {
            baseNCodec$Context.e = true;
        }
        for (int i = 0; i < n2; ++i) {
            byte by;
            byte[] byArray2 = this.ensureBufferSize(this.h, baseNCodec$Context);
            if ((by = byArray[n++]) == this.pad) {
                baseNCodec$Context.e = true;
                break;
            }
            if (by < 0 || by >= d.length || (by = d[by]) < 0) continue;
            baseNCodec$Context.g = (baseNCodec$Context.g + 1) % 4;
            baseNCodec$Context.a = (baseNCodec$Context.a << 6) + by;
            if (baseNCodec$Context.g != 0) continue;
            byArray2[baseNCodec$Context.c++] = (byte)(baseNCodec$Context.a >> 16);
            byArray2[baseNCodec$Context.c++] = (byte)(baseNCodec$Context.a >> 8);
            byArray2[baseNCodec$Context.c++] = (byte)baseNCodec$Context.a;
        }
        if (baseNCodec$Context.e && baseNCodec$Context.g != 0) {
            byte[] byArray3 = this.ensureBufferSize(this.h, baseNCodec$Context);
            switch (baseNCodec$Context.g) {
                case 1: {
                    return;
                }
                case 2: {
                    baseNCodec$Context.a >>= 4;
                    byArray3[baseNCodec$Context.c++] = (byte)baseNCodec$Context.a;
                    return;
                }
                case 3: {
                    baseNCodec$Context.a >>= 2;
                    byArray3[baseNCodec$Context.c++] = (byte)(baseNCodec$Context.a >> 8);
                    byArray3[baseNCodec$Context.c++] = (byte)baseNCodec$Context.a;
                    return;
                }
            }
            throw new IllegalStateException("Impossible modulus " + baseNCodec$Context.g);
        }
    }

    public static boolean isArrayByteBase64(byte[] byArray) {
        return Base64.isBase64(byArray);
    }

    public static boolean isBase64(byte by) {
        return by == 61 || by >= 0 && by < d.length && d[by] != -1;
    }

    public static boolean isBase64(String string) {
        return Base64.isBase64(StringUtils.getBytesUtf8(string));
    }

    public static boolean isBase64(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if (Base64.isBase64(byArray[i]) || Base64.isWhiteSpace(byArray[i])) continue;
            return false;
        }
        return true;
    }

    public static byte[] encodeBase64(byte[] byArray) {
        return Base64.encodeBase64(byArray, false);
    }

    public static String encodeBase64String(byte[] byArray) {
        return StringUtils.newStringUtf8(Base64.encodeBase64(byArray, false));
    }

    public static byte[] encodeBase64URLSafe(byte[] byArray) {
        return Base64.encodeBase64(byArray, false, true);
    }

    public static String encodeBase64URLSafeString(byte[] byArray) {
        return StringUtils.newStringUtf8(Base64.encodeBase64(byArray, false, true));
    }

    public static byte[] encodeBase64Chunked(byte[] byArray) {
        return Base64.encodeBase64(byArray, true);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl) {
        return Base64.encodeBase64(byArray, bl, false);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl, boolean bl2) {
        return Base64.encodeBase64(byArray, bl, bl2, Integer.MAX_VALUE);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl, boolean bl2, int n) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        Base64 base64 = bl ? new Base64(bl2) : new Base64(0, a, bl2);
        long l = base64.getEncodedLength(byArray);
        if (l > (long)n) {
            throw new IllegalArgumentException("Input array too big, the output array would be bigger (" + l + ") than the specified maximum size of " + n);
        }
        return base64.encode(byArray);
    }

    public static byte[] decodeBase64(String string) {
        return new Base64().decode(string);
    }

    public static byte[] decodeBase64(byte[] byArray) {
        return new Base64().decode(byArray);
    }

    public static BigInteger decodeInteger(byte[] byArray) {
        return new BigInteger(1, Base64.decodeBase64(byArray));
    }

    public static byte[] encodeInteger(BigInteger bigInteger) {
        byte[] byArray;
        if (bigInteger == null) {
            throw new NullPointerException("encodeInteger called with null parameter");
        }
        int n = bigInteger.bitLength();
        n = n + 7 >> 3 << 3;
        byte[] byArray2 = bigInteger.toByteArray();
        if (bigInteger.bitLength() % 8 != 0 && bigInteger.bitLength() / 8 + 1 == n / 8) {
            byArray = byArray2;
        } else {
            int n2 = 0;
            int n3 = byArray2.length;
            if (bigInteger.bitLength() % 8 == 0) {
                n2 = 1;
                --n3;
            }
            int n4 = n / 8 - n3;
            byte[] byArray3 = new byte[n / 8];
            System.arraycopy(byArray2, n2, byArray3, n4, n3);
            byArray = byArray3;
        }
        return Base64.encodeBase64(byArray, false);
    }

    @Override
    protected boolean isInAlphabet(byte by) {
        return by >= 0 && by < this.f.length && this.f[by] != -1;
    }
}

