/*
 * Decompiled with CFR 0.152.
 */
package com.yunpian.sdk.api;

import com.google.gson.reflect.TypeToken;
import com.yunpian.sdk.YunpianClient;
import com.yunpian.sdk.api.YunpianApi;
import com.yunpian.sdk.api.YunpianApiResult;
import com.yunpian.sdk.model.Result;
import com.yunpian.sdk.model.SmsBatchSend;
import com.yunpian.sdk.model.SmsSingleSend;
import com.yunpian.sdk.model.Template;
import com.yunpian.sdk.util.HttpEntityWrapper;
import com.yunpian.sdk.util.JsonUtil;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class VideoSmsApi
extends YunpianApi {
    public static final String NAME = "vsms";
    private static final Type TypeListBatch = new TypeToken<List<SmsSingleSend>>(){}.getType();

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void init(YunpianClient clnt) {
        super.init(clnt);
        this.host(clnt.getConf().getConf("yp.vsms.host", "https://vsms.yunpian.com"));
    }

    public Result<Template> addTpl(Map<String, String> param, String layout, byte[] material) {
        Result<Template> r = new Result<Template>();
        if (layout == null || material == null) {
            return r.setCode(1);
        }
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "sign");
        if (r.getCode() != 0) {
            return r;
        }
        Charset ch = Charset.forName(this.charset());
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setCharset(ch).setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (NameValuePair pair : list) {
            builder.addTextBody(pair.getName(), pair.getValue(), ContentType.create((String)"text/plain", (Charset)ch));
        }
        builder.addTextBody("layout", layout, ContentType.APPLICATION_JSON);
        builder.addBinaryBody("material", material, ContentType.create((String)"application/octet-stream", (Charset)ch), null);
        YunpianApiResult.StdResultHandler<Template> h = new YunpianApiResult.StdResultHandler<Template>(new TypeToken<Result<Template>>(){}.getType());
        try {
            return this.path("add_tpl.json").post(new HttpEntityWrapper(builder.build()), h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<Template> getTpl(Map<String, String> param) {
        Result<Template> r = new Result<Template>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "tpl_id");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.StdResultHandler<Template> h = new YunpianApiResult.StdResultHandler<Template>(new TypeToken<Result<Template>>(){}.getType());
        try {
            return this.path("get_tpl.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<SmsBatchSend> tplBatchSend(Map<String, String> param) {
        Result<SmsBatchSend> r = new Result<SmsBatchSend>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "tpl_id", "mobile");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<SmsBatchSend> h = new YunpianApiResult.MapResultHandler<SmsBatchSend>(){

            @Override
            public SmsBatchSend data(Map<String, String> rsp) {
                switch (VideoSmsApi.this.version()) {
                    case "v2": {
                        return VideoSmsApi.this.map2SendBatchSmsInfo(rsp);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, VideoSmsApi.this.version());
            }
        };
        try {
            return this.path("tpl_batch_send.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    protected SmsBatchSend map2SendBatchSmsInfo(Map<String, String> rsp) {
        if (rsp != null) {
            try {
                SmsBatchSend info = new SmsBatchSend();
                info.setTotal_count(Integer.parseInt(rsp.get("total_count")));
                info.setTotal_fee(Double.parseDouble(rsp.get("total_fee")));
                info.setUnit(rsp.get("unit"));
                String data = rsp.get("data");
                if (data != null && data.startsWith("[")) {
                    info.setData((List)JsonUtil.fromJson(data, TypeListBatch));
                }
                return info;
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e.fillInStackTrace());
            }
        }
        return null;
    }
}

