/*
 * Decompiled with CFR 0.152.
 */
package com.yunpian.sdk.api;

import com.google.gson.reflect.TypeToken;
import com.yunpian.sdk.YunpianClient;
import com.yunpian.sdk.api.YunpianApi;
import com.yunpian.sdk.api.YunpianApiResult;
import com.yunpian.sdk.model.Result;
import com.yunpian.sdk.model.Template;
import com.yunpian.sdk.util.JsonUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class TplApi
extends YunpianApi {
    public static final String NAME = "tpl";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void init(YunpianClient clnt) {
        super.init(clnt);
        this.host(clnt.getConf().getConf("yp.tpl.host", "https://sms.yunpian.com"));
    }

    public Result<List<Template>> get_default(Map<String, String> param) {
        Result<List<Template>> r = new Result<List<Template>>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.SimpleListResultHandler<Template> h = new YunpianApiResult.SimpleListResultHandler<Template>(){

            @Override
            public List<Template> data(List<Template> rsp) {
                switch (TplApi.this.version()) {
                    case "v2": {
                        return rsp;
                    }
                }
                return Collections.emptyList();
            }

            @Override
            public Integer code(List<Template> rsp) {
                if (this.rspMap != null) {
                    return YunpianApi.code(this.rspMap, TplApi.this.version());
                }
                return 0;
            }

            @Override
            Type rspType() {
                return new TypeToken<List<Template>>(){}.getType();
            }
        };
        try {
            return this.path("get_default.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<List<Template>> get(Map<String, String> param) {
        Result<List<Template>> r = new Result<List<Template>>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.SimpleListResultHandler<Template> h = new YunpianApiResult.SimpleListResultHandler<Template>(){

            @Override
            public List<Template> data(List<Template> rsp) {
                switch (TplApi.this.version()) {
                    case "v1": {
                        if (this.rspMap == null) break;
                        String t = (String)this.rspMap.get("template");
                        return t.startsWith("[") ? (List<Template>)JsonUtil.fromJson(t, new TypeToken<ArrayList<Template>>(){}.getType()) : Arrays.asList(JsonUtil.fromJson(t, Template.class));
                    }
                    case "v2": {
                        if (this.rspMap != null) {
                            Template tpl = TplApi.this.map2Template(this.rspMap);
                            return tpl == null ? null : Arrays.asList(tpl);
                        }
                        return rsp;
                    }
                }
                return Collections.emptyList();
            }

            @Override
            public Integer code(List<Template> rsp) {
                if (this.rspMap != null) {
                    return YunpianApi.code(this.rspMap, TplApi.this.version());
                }
                return 0;
            }

            @Override
            Type rspType() {
                return new TypeToken<List<Template>>(){}.getType();
            }
        };
        try {
            return this.path("get.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<Template> add(Map<String, String> param) {
        Result<Template> r = new Result<Template>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "tpl_content");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<Template> h = new YunpianApiResult.MapResultHandler<Template>(){

            @Override
            public Template data(Map<String, String> rsp) {
                switch (TplApi.this.version()) {
                    case "v1": {
                        return JsonUtil.fromJson(rsp.get("template"), Template.class);
                    }
                    case "v2": {
                        return TplApi.this.map2Template(rsp);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, TplApi.this.version());
            }
        };
        try {
            return this.path("add.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<Template> del(Map<String, String> param) {
        Result<Template> r = new Result<Template>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "tpl_id");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<Template> h = new YunpianApiResult.MapResultHandler<Template>(){

            @Override
            public Template data(Map<String, String> rsp) {
                switch (TplApi.this.version()) {
                    case "v2": {
                        return TplApi.this.map2Template(rsp);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, TplApi.this.version());
            }
        };
        try {
            return this.path("del.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<Template> update(Map<String, String> param) {
        Result<Template> r = new Result<Template>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "tpl_id", "tpl_content");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<Template> h = new YunpianApiResult.MapResultHandler<Template>(){

            @Override
            public Template data(Map<String, String> rsp) {
                switch (TplApi.this.version()) {
                    case "v1": {
                        if (rsp.containsKey("template")) {
                            return JsonUtil.fromJson(rsp.get("template"), Template.class);
                        }
                    }
                    case "v2": {
                        if (rsp.containsKey("template")) {
                            return JsonUtil.fromJson(rsp.get("template"), Template.class);
                        }
                        return TplApi.this.map2Template(rsp);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, TplApi.this.version());
            }
        };
        try {
            return this.path("update.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<Template> add_voice_notify(Map<String, String> param) {
        Result<Template> r = new Result<Template>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "tpl_content");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<Template> h = new YunpianApiResult.MapResultHandler<Template>(){

            @Override
            public Template data(Map<String, String> rsp) {
                switch (TplApi.this.version()) {
                    case "v2": {
                        return TplApi.this.map2Template(rsp);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, TplApi.this.version());
            }
        };
        try {
            return this.path("add_voice_notify.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<Template> update_voice_notify(Map<String, String> param) {
        Result<Template> r = new Result<Template>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "tpl_id", "tpl_content");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<Template> h = new YunpianApiResult.MapResultHandler<Template>(){

            @Override
            public Template data(Map<String, String> rsp) {
                switch (TplApi.this.version()) {
                    case "v2": {
                        if (rsp.containsKey("template")) {
                            return JsonUtil.fromJson(rsp.get("template"), Template.class);
                        }
                        return TplApi.this.map2Template(rsp);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, TplApi.this.version());
            }
        };
        try {
            return this.path("update_voice_notify.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    private Template map2Template(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        try {
            Template t = new Template();
            t.setCheck_status(map.get("check_status"));
            t.setReason(map.get("reason"));
            t.setTpl_content(map.get("tpl_content"));
            t.setTpl_id(Long.parseLong(map.get("tpl_id")));
            return t;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e.fillInStackTrace());
            return null;
        }
    }
}

