/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.sql.datasource;

import com.yomahub.liteflow.parser.sql.datasource.LiteFlowDataSourceConnect;
import com.yomahub.liteflow.parser.sql.datasource.impl.BaoMiDouDynamicDsConn;
import com.yomahub.liteflow.parser.sql.datasource.impl.DefaultLiteFlowJdbcConn;
import com.yomahub.liteflow.parser.sql.datasource.impl.LiteFlowAutoLookUpJdbcConn;
import com.yomahub.liteflow.parser.sql.datasource.impl.ShardingJdbcDsConn;
import com.yomahub.liteflow.parser.sql.vo.SQLParserVO;
import com.yomahub.liteflow.spi.ContextAware;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteflowDataSourceConnectFactory {
    private static final List<LiteFlowDataSourceConnect> CONNECT_LIST = new CopyOnWriteArrayList<LiteFlowDataSourceConnect>();
    private static final Logger LOG = LoggerFactory.getLogger(LiteflowDataSourceConnectFactory.class);

    public static void register() {
        ContextAware contextAware = ContextAwareHolder.loadContextAware();
        Map beanMap = contextAware.getBeansOfType(LiteFlowDataSourceConnect.class);
        Collection values = beanMap.values();
        CONNECT_LIST.clear();
        CONNECT_LIST.addAll(values);
        CONNECT_LIST.add(new DefaultLiteFlowJdbcConn());
        CONNECT_LIST.add(new BaoMiDouDynamicDsConn());
        CONNECT_LIST.add(new ShardingJdbcDsConn());
        CONNECT_LIST.add(new LiteFlowAutoLookUpJdbcConn());
    }

    public static Optional<LiteFlowDataSourceConnect> getConnect(SQLParserVO config) {
        for (LiteFlowDataSourceConnect dataSourceConnect : CONNECT_LIST) {
            if (!dataSourceConnect.filter(config)) continue;
            LOG.debug("use lite-flow-data-source-connect: {}", (Object)dataSourceConnect.getClass().getName());
            return Optional.of(dataSourceConnect);
        }
        return Optional.empty();
    }
}

