/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder.el;

import cn.hutool.core.util.ObjectUtil;
import com.yomahub.liteflow.builder.el.AndELWrapper;
import com.yomahub.liteflow.builder.el.CommonNodeELWrapper;
import com.yomahub.liteflow.builder.el.ELBus;
import com.yomahub.liteflow.builder.el.ELWrapper;
import com.yomahub.liteflow.builder.el.NotELWrapper;
import com.yomahub.liteflow.builder.el.OrELWrapper;
import java.util.Map;
import java.util.Objects;

public class IfELWrapper
extends ELWrapper {
    private static final int IF_FORMAT = 1;
    private static final int IF_ELSE_FORMAT = 2;
    private static final int ELIF_FORMAT = 3;
    private int format;

    public IfELWrapper(CommonNodeELWrapper ifWrapper, ELWrapper trueWrapper, ELWrapper falseWrapper) {
        this.setIfWrapper(ifWrapper);
        this.setTrueWrapper(trueWrapper);
        this.setFalseWrapper(falseWrapper);
        this.format = 1;
    }

    public IfELWrapper(CommonNodeELWrapper ifWrapper, ELWrapper trueWrapper) {
        this.setIfWrapper(ifWrapper);
        this.setTrueWrapper(trueWrapper);
        this.format = 2;
    }

    public IfELWrapper(AndELWrapper andElWrapper, ELWrapper trueWrapper, ELWrapper falseWrapper) {
        this.setIfWrapper(andElWrapper);
        this.setTrueWrapper(trueWrapper);
        this.setFalseWrapper(falseWrapper);
        this.format = 1;
    }

    public IfELWrapper(AndELWrapper andElWrapper, ELWrapper trueWrapper) {
        this.setIfWrapper(andElWrapper);
        this.setTrueWrapper(trueWrapper);
        this.format = 2;
    }

    public IfELWrapper(OrELWrapper andElWrapper, ELWrapper trueWrapper, ELWrapper falseWrapper) {
        this.setIfWrapper(andElWrapper);
        this.setTrueWrapper(trueWrapper);
        this.setFalseWrapper(falseWrapper);
        this.format = 1;
    }

    public IfELWrapper(OrELWrapper andElWrapper, ELWrapper trueWrapper) {
        this.setIfWrapper(andElWrapper);
        this.setTrueWrapper(trueWrapper);
        this.format = 2;
    }

    public IfELWrapper(NotELWrapper andElWrapper, ELWrapper trueWrapper, ELWrapper falseWrapper) {
        this.setIfWrapper(andElWrapper);
        this.setTrueWrapper(trueWrapper);
        this.setFalseWrapper(falseWrapper);
        this.format = 1;
    }

    public IfELWrapper(NotELWrapper andElWrapper, ELWrapper trueWrapper) {
        this.setIfWrapper(andElWrapper);
        this.setTrueWrapper(trueWrapper);
        this.format = 2;
    }

    public IfELWrapper elseOpt(Object falseObject) {
        ELWrapper falseWrapper = ELBus.convertToNonBooleanOpt(falseObject);
        IfELWrapper prev = this;
        IfELWrapper succ = this;
        while (prev instanceof IfELWrapper) {
            succ = prev;
            prev = prev.getElWrapperList().size() >= 3 ? prev.getElWrapperList().get(2) : null;
        }
        succ.setFalseWrapper(falseWrapper);
        return this;
    }

    public IfELWrapper elIfOpt(Object ifObject, Object trueObject) {
        IfELWrapper elIfWrapper;
        ELWrapper ifWrapper = ELBus.convertToBooleanOpt(ifObject);
        ELWrapper trueWrapper = ELBus.convertToNonBooleanOpt(trueObject);
        if (ifWrapper instanceof CommonNodeELWrapper) {
            elIfWrapper = new IfELWrapper((CommonNodeELWrapper)ifWrapper, trueWrapper);
        } else if (ifWrapper instanceof AndELWrapper) {
            elIfWrapper = new IfELWrapper((AndELWrapper)ifWrapper, trueWrapper);
        } else if (ifWrapper instanceof OrELWrapper) {
            elIfWrapper = new IfELWrapper((OrELWrapper)ifWrapper, trueWrapper);
        } else if (ifWrapper instanceof NotELWrapper) {
            elIfWrapper = new IfELWrapper((NotELWrapper)ifWrapper, trueWrapper);
        } else {
            throw new RuntimeException("param error!");
        }
        elIfWrapper.setFormat(3);
        IfELWrapper prev = this;
        IfELWrapper succ = this;
        while (prev instanceof IfELWrapper) {
            succ = prev;
            prev = prev.getElWrapperList().size() >= 3 ? prev.getElWrapperList().get(2) : null;
        }
        succ.elseOpt(elIfWrapper);
        return this;
    }

    private void setIfWrapper(ELWrapper ifWrapper) {
        this.addWrapper(ifWrapper, 0);
    }

    private ELWrapper getIfWrapper() {
        return this.getElWrapperList().get(0);
    }

    private void setTrueWrapper(ELWrapper trueWrapper) {
        this.addWrapper(trueWrapper, 1);
    }

    private ELWrapper getTrueWrapper() {
        return this.getElWrapperList().get(1);
    }

    private void setFalseWrapper(ELWrapper falseWrapper) {
        this.addWrapper(falseWrapper, 2);
    }

    protected void setFormat(int formatCode) {
        this.format = formatCode;
    }

    protected int getFormat() {
        return this.format;
    }

    private ELWrapper getFalseWrapper() {
        try {
            return this.getElWrapperList().get(2);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public IfELWrapper tag(String tag) {
        this.setTag(tag);
        return this;
    }

    @Override
    public IfELWrapper id(String id) {
        this.setId(id);
        return this;
    }

    @Override
    public IfELWrapper data(String dataName, Object object) {
        super.data(dataName, object);
        return this;
    }

    @Override
    public IfELWrapper data(String dataName, String jsonString) {
        super.data(dataName, jsonString);
        return this;
    }

    @Override
    public IfELWrapper data(String dataName, Map<String, Object> jsonMap) {
        super.data(dataName, jsonMap);
        return this;
    }

    @Override
    public IfELWrapper bind(String key, String value) {
        super.bind(key, value);
        return this;
    }

    @Override
    public IfELWrapper maxWaitSeconds(Integer maxWaitSeconds) {
        this.setMaxWaitSeconds(maxWaitSeconds);
        return this;
    }

    public IfELWrapper retry(Integer count) {
        super.retry(count);
        return this;
    }

    public IfELWrapper retry(Integer count, String ... exceptions) {
        super.retry(count, exceptions);
        return this;
    }

    @Override
    protected String toEL(Integer depth, StringBuilder paramContext) {
        Integer sonDepth = depth == null ? null : Integer.valueOf(depth + 1);
        StringBuilder sb = new StringBuilder();
        this.processWrapperTabs(sb, depth);
        switch (this.format) {
            case 1: {
                sb.append("IF(");
                this.processWrapperNewLine(sb, depth);
                sb.append(this.getIfWrapper().toEL(sonDepth, paramContext)).append(",");
                this.processWrapperNewLine(sb, depth);
                sb.append(this.getTrueWrapper().toEL(sonDepth, paramContext)).append(",");
                this.processWrapperNewLine(sb, depth);
                sb.append(Objects.requireNonNull(this.getFalseWrapper()).toEL(sonDepth, paramContext));
                this.processWrapperNewLine(sb, depth);
                this.processWrapperTabs(sb, depth);
                sb.append(")");
                break;
            }
            case 2: {
                sb.append("IF(");
                this.processWrapperNewLine(sb, depth);
                sb.append(this.getIfWrapper().toEL(sonDepth, paramContext)).append(",");
                this.processWrapperNewLine(sb, depth);
                sb.append(this.getTrueWrapper().toEL(sonDepth, paramContext));
                this.processWrapperNewLine(sb, depth);
                this.processWrapperTabs(sb, depth);
                sb.append(")");
                this.processElseOutPut(depth, sonDepth, sb, paramContext);
                break;
            }
            case 3: {
                sb.append(".ELIF(");
                this.processWrapperNewLine(sb, depth);
                sb.append(this.getIfWrapper().toEL(sonDepth, paramContext)).append(",");
                this.processWrapperNewLine(sb, depth);
                sb.append(this.getTrueWrapper().toEL(sonDepth, paramContext));
                this.processWrapperNewLine(sb, depth);
                this.processWrapperTabs(sb, depth);
                sb.append(")");
                this.processElseOutPut(depth, sonDepth, sb, paramContext);
                break;
            }
        }
        this.processWrapperProperty(sb, paramContext);
        return sb.toString();
    }

    private void processElseOutPut(Integer depth, Integer sonDepth, StringBuilder elContext, StringBuilder paramContext) {
        if (ObjectUtil.isNotNull((Object)this.getFalseWrapper())) {
            if (this.getFalseWrapper() instanceof IfELWrapper && ((IfELWrapper)this.getFalseWrapper()).getFormat() == 3) {
                elContext.append(this.getFalseWrapper().toEL(depth, paramContext));
            } else {
                elContext.append(".ELSE(");
                this.processWrapperNewLine(elContext, depth);
                elContext.append(this.getFalseWrapper().toEL(sonDepth, paramContext));
                this.processWrapperNewLine(elContext, depth);
                this.processWrapperTabs(elContext, depth);
                elContext.append(")");
            }
        }
    }
}

