/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.script.jsr223;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.exception.LiteFlowException;
import com.yomahub.liteflow.script.ScriptBeanManager;
import com.yomahub.liteflow.script.ScriptExecuteWrap;
import com.yomahub.liteflow.script.ScriptExecutor;
import com.yomahub.liteflow.script.exception.ScriptLoadException;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import com.yomahub.liteflow.util.CopyOnWriteHashMap;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JSR223ScriptExecutor
implements ScriptExecutor {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ScriptEngine scriptEngine;
    private final Map<String, CompiledScript> compiledScriptMap = new CopyOnWriteHashMap<String, CompiledScript>();

    @Override
    public ScriptExecutor init() {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        this.scriptEngine = scriptEngineManager.getEngineByName(this.scriptEngineName());
        return this;
    }

    protected abstract String scriptEngineName();

    protected String convertScript(String script) {
        return script;
    }

    @Override
    public void load(String nodeId, String script) {
        try {
            CompiledScript compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(this.convertScript(script));
            this.compiledScriptMap.put(nodeId, compiledScript);
        }
        catch (Exception e) {
            String errorMsg = StrUtil.format((CharSequence)"script loading error for node[{}], error msg:{}", (Object[])new Object[]{nodeId, e.getMessage()});
            throw new ScriptLoadException(errorMsg);
        }
    }

    @Override
    public Object execute(ScriptExecuteWrap wrap) throws Exception {
        try {
            if (!this.compiledScriptMap.containsKey(wrap.getNodeId())) {
                String errorMsg = StrUtil.format((CharSequence)"script for node[{}] is not loaded", (Object[])new Object[]{wrap.getNodeId()});
                throw new ScriptLoadException(errorMsg);
            }
            CompiledScript compiledScript = this.compiledScriptMap.get(wrap.getNodeId());
            SimpleBindings bindings = new SimpleBindings();
            DataBus.getContextBeanList(wrap.getSlotIndex()).forEach(o -> {
                String key = StrUtil.lowerFirst((CharSequence)o.getClass().getSimpleName());
                bindings.put(key, o);
            });
            Map metaMap = BeanUtil.beanToMap((Object)wrap, (String[])new String[0]);
            Slot slot = DataBus.getSlot(wrap.getSlotIndex());
            metaMap.put("requestData", slot.getRequestData());
            Object subRequestData = slot.getChainReqData(wrap.getCurrChainId());
            if (ObjectUtil.isNotNull(subRequestData)) {
                metaMap.put("subRequestData", subRequestData);
            }
            bindings.put("_meta", (Object)metaMap);
            ScriptBeanManager.getScriptBeanMap().forEach(bindings::putIfAbsent);
            return compiledScript.eval(bindings);
        }
        catch (Exception e) {
            if (ObjectUtil.isNotNull((Object)e.getCause()) && e.getCause() instanceof LiteFlowException) {
                throw (LiteFlowException)e.getCause();
            }
            if (ObjectUtil.isNotNull((Object)e.getCause()) && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void cleanCache() {
        this.compiledScriptMap.clear();
    }
}

