/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.NoWhileNodeException;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.element.condition.LoopCondition;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import com.yomahub.liteflow.util.LiteFlowProxyUtil;

public class WhileCondition
extends LoopCondition {
    private Node whileNode;

    @Override
    public void execute(Integer slotIndex) throws Exception {
        Slot slot = DataBus.getSlot(slotIndex);
        if (ObjectUtil.isNull((Object)this.whileNode)) {
            String errorInfo = StrUtil.format((CharSequence)"[{}]:no while-node found", (Object[])new Object[]{slot.getRequestId()});
            throw new NoWhileNodeException(errorInfo);
        }
        Executable executableItem = this.getDoExecutor();
        int index = 0;
        while (this.getWhileResult(slotIndex)) {
            executableItem.setCurrChainId(this.getCurrChainId());
            this.setLoopIndex(executableItem, index);
            executableItem.execute(slotIndex);
            if (ObjectUtil.isNotNull((Object)this.breakNode)) {
                this.breakNode.setCurrChainId(this.getCurrChainId());
                this.setLoopIndex(this.breakNode, index);
                this.breakNode.execute(slotIndex);
                Class<?> originalBreakClass = LiteFlowProxyUtil.getUserClass(this.breakNode.getInstance().getClass());
                boolean isBreak = slot.getBreakResult(originalBreakClass.getName());
                if (isBreak) break;
            }
            ++index;
        }
    }

    private boolean getWhileResult(Integer slotIndex) throws Exception {
        Slot slot = DataBus.getSlot(slotIndex);
        this.whileNode.setCurrChainId(this.getCurrChainId());
        this.whileNode.execute(slotIndex);
        Class<?> originalWhileClass = LiteFlowProxyUtil.getUserClass(this.whileNode.getInstance().getClass());
        return slot.getWhileResult(originalWhileClass.getName());
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_WHILE;
    }

    public Node getWhileNode() {
        return this.whileNode;
    }

    public void setWhileNode(Node whileNode) {
        this.whileNode = whileNode;
    }
}

