/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.ChainEndException;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.condition.Condition;
import com.yomahub.liteflow.flow.element.condition.FinallyCondition;
import com.yomahub.liteflow.flow.element.condition.PreCondition;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ThenCondition
extends Condition {
    private final List<PreCondition> preConditionList = new ArrayList<PreCondition>();
    private final List<FinallyCondition> finallyConditionList = new ArrayList<FinallyCondition>();

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_THEN;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(Integer slotIndex) throws Exception {
        try {
            for (PreCondition preCondition : this.preConditionList) {
                preCondition.setCurrChainId(this.getCurrChainId());
                preCondition.execute(slotIndex);
            }
            for (Executable executableItem : this.getExecutableList()) {
                executableItem.setCurrChainId(this.getCurrChainId());
                executableItem.execute(slotIndex);
            }
        }
        catch (ChainEndException e) {
            try {
                throw e;
                catch (Exception e2) {
                    Slot slot = DataBus.getSlot(slotIndex);
                    String chainId = this.getCurrChainId();
                    if (slot.isSubChain(chainId)) {
                        slot.setSubException(chainId, e2);
                        throw e2;
                    }
                    slot.setException(e2);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                Iterator<FinallyCondition> iterator = this.finallyConditionList.iterator();
                while (iterator.hasNext()) {
                    FinallyCondition finallyCondition = iterator.next();
                    finallyCondition.setCurrChainId(this.getCurrChainId());
                    finallyCondition.execute(slotIndex);
                }
                throw throwable;
            }
        }
        Iterator<Executable> iterator = this.finallyConditionList.iterator();
        while (iterator.hasNext()) {
            FinallyCondition finallyCondition = (FinallyCondition)iterator.next();
            finallyCondition.setCurrChainId(this.getCurrChainId());
            finallyCondition.execute(slotIndex);
        }
    }

    @Override
    public void addExecutable(Executable executable) {
        if (executable instanceof PreCondition) {
            this.preConditionList.add((PreCondition)executable);
        } else if (executable instanceof FinallyCondition) {
            this.finallyConditionList.add((FinallyCondition)executable);
        } else {
            super.addExecutable(executable);
        }
    }
}

