/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.NoIteratorNodeException;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.element.condition.LoopCondition;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import com.yomahub.liteflow.util.LiteFlowProxyUtil;
import java.util.Iterator;

public class IteratorCondition
extends LoopCondition {
    private Node iteratorNode;

    @Override
    public void execute(Integer slotIndex) throws Exception {
        Slot slot = DataBus.getSlot(slotIndex);
        if (ObjectUtil.isNull((Object)this.iteratorNode)) {
            String errorInfo = StrUtil.format((CharSequence)"[{}]:no iterator-node found", (Object[])new Object[]{slot.getRequestId()});
            throw new NoIteratorNodeException(errorInfo);
        }
        this.iteratorNode.setCurrChainId(this.getCurrChainId());
        this.iteratorNode.execute(slotIndex);
        Class<?> originalForCountClass = LiteFlowProxyUtil.getUserClass(this.iteratorNode.getInstance().getClass());
        Iterator<?> it = slot.getIteratorResult(originalForCountClass.getName());
        Executable executableItem = this.getDoExecutor();
        int index = 0;
        while (it.hasNext()) {
            Object itObj = it.next();
            executableItem.setCurrChainId(this.getCurrChainId());
            this.setLoopIndex(executableItem, index);
            this.setCurrLoopObject(executableItem, itObj);
            executableItem.execute(slotIndex);
            if (ObjectUtil.isNotNull((Object)this.breakNode)) {
                this.breakNode.setCurrChainId(this.getCurrChainId());
                this.setLoopIndex(this.breakNode, index);
                this.setCurrLoopObject(this.breakNode, itObj);
                this.breakNode.execute(slotIndex);
                Class<?> originalBreakClass = LiteFlowProxyUtil.getUserClass(this.breakNode.getInstance().getClass());
                boolean isBreak = slot.getBreakResult(originalBreakClass.getName());
                if (isBreak) break;
            }
            ++index;
        }
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_ITERATOR;
    }

    public Node getIteratorNode() {
        return this.iteratorNode;
    }

    public void setIteratorNode(Node iteratorNode) {
        this.iteratorNode = iteratorNode;
    }
}

